#' Single-case example data
#'
#' The [scan] package comes with a set of fictitious and authentic
#' single-case study data, by courtesy of the particular authors.
#'
#' @aliases Beretvas2008 Borckardt2014 Huitema2000 Waddell2011 byHeart2011
#'   Grosche2011 Grosche2014 GruenkeWilbert2014 Huber2014 example_A24
#'   exampleAB_simple exampleAB exampleAB_add exampleAB_decreasing
#'   exampleAB_score exampleABC exampleABC_outlier exampleABC_50 exampleABAB
#'   exampleA1B1A2B2 exampleA1B1A2B2_zvt exampleAB_50 exampleAB_50.l2
#'   exampleABC_150 exampleAB_mpd Huber2014 Lenz2013 Leidig2018 Leidig2018_l2
#'   SSDforR2017 Parker2011
#' @return
#' \item{Beretvas2008}{Fictitious single-case intervention study.
#' **Reference:** Beretvas, S., & Chung, H. (2008). An evaluation of
#' modified R2-change effect size indices for single-subject experimental
#' designs. \emph{Evidence-Based Communication Assessment and Intervention, 2},
#' 120-128.}
#' \item{Borckardt2014}{Fictitious daily pain ratings evaluating a
#' psychological treatment. \bold{Reference:} Borckardt, J. J., & Nash, M. R.
#' (2014). Simulation modelling analysis for small sets of single-subject data
#' collected over time. \emph{Neuropsychological Rehabilitation, 24}, 492-506.}
#' \item{Huitema2000}{Fictitious single-case intervention study.
#' \bold{Reference:} Huitema, B. E., & McKean, J. W. (2000). Design
#' specification issues in time-series intervention models. \emph{Educational
#' and Psychological Measurement, 60}, 38-58.}
#' \item{Waddell2011}{Fictitious
#' single-case intervention study. \bold{Reference:} Waddell, D. E., Nassar, S.
#' L., & Gustafson, S. A. (2011). Single-Case Design in Psychophysiological
#' Research: Part II: Statistical Analytic Approaches. \emph{Journal of
#' Neurotherapy, 15}, 160-169.}
#' \item{byHeart2011}{Multiple-baseline (11 cases)
#' intervention study on flash card vocabulary learning by Juergen Wilbert.}
#' \item{Grosche2011}{Multiple-baseline (3 cases) intervention study on a
#' direct-instructive reading intervention. \bold{Reference:} Grosche, M.
#' (2011). Effekte einer direkt-instruktiven Foerderung der Lesegenauigkeit.
#' \emph{Empirische Sonderpaedagogik, 3}, 147-161.}
#' \item{Grosche2014}{Multiple-baseline (3 cases x 3 materials) intervention
#' study on a reading intervention. \bold{Reference:} Grosche, M., Lueke, T., &
#' Wilbert, J. (in prep.).}
#' \item{GruenkeWilbert2014}{Multiple-baseline (6
#' cases) intervention study on story mapping. \bold{Reference:} Gruenke, M.,
#' Wilbert, J., & Stegemann-Calder, K. (2013). Analyzing the effects of story
#' mapping on the reading comprehension of children with low intellectual
#' abilities. \emph{Learning Disabilities: A Contemporary Journal, 11}, 51-64.}
#' \item{Huber2014}{Multiple-baseline (4 cases) intervention study on
#' behavioral compliance. Scores refer to compliant behavior in percent.
#' \bold{Reference:} Huber, C. (in prep.).}
#' \item{Lenz2013}{Fictious example from the paper Lenz, A. S. (2013).
#' Calculating Effect Size in Single-Case Research: A Comparison of Nonoverlap
#' Methods. Measurement and Evaluation in Counseling and Development, 46(1),
#' 64–73.} \item{Leidig2018}{} \item{Leidig2018_l2}{} \item{SSDforR2017}{Example
#' from the R package SSDforR.} \item{Parker2011}{Example from Parker, R. I.,
#' Vannest, K. J., Davis, J. L., & Sauber, S. B. (2011). Combining Nonoverlap
#' and Trend for Single-Case Research: Tau-U. Behavior Therapy, 42(2), 284–299.
#' https://doi.org/10.1016/j.beth.2010.08.006}
#' @author Juergen Wilbert
#' @keywords internal
#' @name example_data
NULL


