% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau_u.R, R/print.sc_tauu.R, R/export.sc_tauu.R
\name{tau_u}
\alias{tau_u}
\alias{print.sc_tauu}
\alias{export.sc_tauu}
\title{Tau-U for single-case data}
\usage{
tau_u(
  data,
  dvar,
  pvar,
  method = c("complete", "parker", "tarlow"),
  phases = c(1, 2),
  meta_analyses = TRUE,
  ci = 0.95,
  ci_method = c("z", "tau", "s"),
  meta_weight_method = c("z", "tau"),
  tau_method = c("b", "a"),
  continuity_correction = FALSE
)

\method{print}{sc_tauu}(
  x,
  complete = FALSE,
  digits = "auto",
  select = c("Tau", "CI lower", "CI upper", "SD_S", "Z", "p"),
  nice_p = TRUE,
  ...
)

\method{export}{sc_tauu}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  select = "auto",
  meta = FALSE,
  round = 3,
  decimals = 3,
  ...
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{method}{\code{"complete"} (default), \code{"parker"} or \code{"tarlow"}. The
\code{"parker"} calculates the number of possible pairs as described in Parker
et al. (2011) which might lead to tau-U values greater than 1. \code{"tarlow"}
follows an online calculator and R code developed by Tarlow (2017).}

\item{phases}{A vector of two characters or numbers indicating the two phases
that should be compared. E.g., \code{phases = c("A","C")} or \code{phases = c(2,4)}
for comparing the second to the fourth phase. Phases could be combined by
providing a list with two elements. E.g., \code{phases = list(A = c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2 and 4 (as B). Default
is \code{phases = c(1,2)}.}

\item{meta_analyses}{If TRUE, a meta analysis is conducted.}

\item{ci}{Confidence intervals}

\item{ci_method}{String to specify the method for calculating the standard
error of tau. Either "tau", "z", or "s" (not recommended).}

\item{meta_weight_method}{String to specify the method for calculating the
weights of the studies. Either "tau" or "z".}

\item{tau_method}{Character with values "a" or "b" (default) indicating
whether Kendall Tau A or Kendall Tau B is applied. Ignored for methods
'tarlow' and 'parker'.}

\item{continuity_correction}{If TRUE, a continuity correction is applied for
calculating p-values of correlations (here: S will be reduced by one before
calculating Z). Ignored for methods 'tarlow' and 'parker'.}

\item{x}{Object returned from \code{\link[=tau_u]{tau_u()}}.}

\item{complete}{Print all parameters.}

\item{digits}{The minimum number of significant digits to be use.
If set to "auto" (default), values are predefined.}

\item{select}{Character vector with name of variables to be included. When
the vector is named, variables are renamed appropriately.}

\item{nice_p}{If TRUE, p-values are printed in publication friendly form.}

\item{...}{Further arguments passed to the function.}

\item{object}{An scdf or an object exported from a scan function.}

\item{caption}{Character string with table caption. If left NA (default) a
caption will be created based on the exported object.}

\item{footnote}{Character string with table footnote. If left NA (default) a
footnote will be created based on the exported object.}

\item{filename}{String containing the file name. If a filename is given the
output will be written to that file.}

\item{meta}{If TRUE, the results of the meta analysis will be exported. If
FALSE, each single-case is exported.}

\item{round}{Integer passed to the digits argument internally used to round
values.}

\item{decimals}{Decimal places that are reported.}
}
\value{
\item{table}{A data frame containing statistics from the Tau-U
family, including: Pairs, positive and negative comparisons, S, and Tau}
\item{matrix}{The matrix of comparisons used for calculating the
statistics.} \item{tau_u}{Tau-U value.}
}
\description{
This function calculates indices of the Tau-U family as proposed by Parker et
al. (2011a).
}
\details{
Tau-U is an inconsistently operationalized construct. Parker et al.
(2011b) describe a method which may result in Tau-U outside the [-1;1]
interval. A different implementation of the method (provided at
http://www.singlecaseresearch.org/calculators/tau-u) uses tau-b (instead of
tau-a as in the original formulation by Parker). Bossart et. al (2018)
describe inconsistencies in the results from this implementation as well.
Another problems lies in the calculation in overall Tau-U values from
several single cases. The function presented here applies a meta-analysis
to gain the overall values. Each tau value is weighted by the inverse of
the variance (ie. the tau standard error). The confidence intervals for
single cases are calculated by Fisher-Z transforming tau, calculating the
confidence intervals, and inverse transform them back to tau (see Long &
Cliff, 1997).
}
\section{Functions}{
\itemize{
\item \code{print(sc_tauu)}: Print results

\item \code{export(sc_tauu)}: Export results as html table

}}
\examples{

tau_u(Grosche2011$Eva)

## Replicate  tau-U calculation from Parker et al. (2011)
bob <- scdf(c(A = 2, 3, 5, 3, B = 4, 5, 5, 7, 6), name = "Bob")
res <- tau_u(bob, method = "parker")
print(res, complete = TRUE)

## Request tau-U for all single-cases from the Grosche2011 data set
tau_u(Grosche2011)
}
\references{
Brossart, D. F., Laird, V. C., & Armstrong, T. W. (2018).
Interpreting Kendall’s Tau and Tau-U for single-case experimental designs.
\emph{Cogent Psychology, 5(1)}, 1–26.
https://doi.org/10.1080/23311908.2018.1518687.

Long, J. D., & Cliff, N. (1997). Confidence intervals for Kendall’s tau.
\emph{British Journal of Mathematical and Statistical Psychology}, 50(1),
31–41. https://doi.org/10.1111/j.2044-8317.1997.tb01100.x

Parker, R. I., Vannest, K. J., & Davis, J. L. (2011a). Effect Size in
Single-Case Research: A Review of Nine Nonoverlap Techniques.
\emph{Behavior Modification}, 35(4), 303–322. https://doi.org/10/dsdfs4

Parker, R. I., Vannest, K. J., Davis, J. L., & Sauber, S. B. (2011b).
Combining Nonoverlap and Trend for Single-Case Research: Tau-U.
\emph{Behavior Therapy, 42}(2), 284–299.
https://doi.org/10.1016/j.beth.2010.08.006

Tarlow, K. R. (2017, March). Tau-U for single-case research (R code).
Retrieved from http://ktarlow.com/stats/
}
\seealso{
Other overlap functions: 
\code{\link{cdc}()},
\code{\link{ird}()},
\code{\link{nap}()},
\code{\link{overlap}()},
\code{\link{pand}()},
\code{\link{pem}()},
\code{\link{pet}()},
\code{\link{pnd}()}
}
\author{
Juergen Wilbert
}
\concept{overlap functions}
