% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zone_utility_functions.R
\name{partition_zones}
\alias{partition_zones}
\title{Partition a set of zones.}
\usage{
partition_zones(zones, n_parts = min(10L, length(zones)))
}
\arguments{
\item{zones}{A \code{set} of zones, each zone itself being a \code{set}
containing locations. Locations should be encoded as integers.}

\item{n_parts}{An integer; the number of parts to split the \code{zones} 
into.}
}
\value{
A list with two elements:
   \itemize{
     \item{partition} A list, each element of which is a \code{set} 
       containing one or more zones (\code{set} containing locations).
     \item{offsets} An integer vector containing offset numbers to the
       zone numbering. For example, the first zone in 
       \code{partition[i]} will have will be zone number 
       \code{offset[i] + 1}.
   }
}
\description{
Partition a set of zones such that each part contains about the same number 
of locations, when the number of locations in each zone for the part are 
summed over all zones in the part.
}
\keyword{internal}

