% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence-interval-functions.R
\name{CI_g}
\alias{CI_g}
\title{Approximate confidence interval for BC-SMD effect size estimates}
\usage{
CI_g(g, cover = 0.95, bound = 35)
}
\arguments{
\item{g}{an estimated effect size object of class \code{g_REML} or \code{g_HPS}}

\item{cover}{confidence level}

\item{bound}{numerical tolerance for non-centrality parameter in \code{\link{qt}}.}
}
\value{
A vector of upper and lower confidence bounds.
}
\description{
Calculates an approximate confidence interval given a \code{g_REML} or \code{g_HPS}
object, based on a non-central t approximation.
}
\examples{
data(Laski)
Laski_RML <- lme(fixed = outcome ~ treatment,
                 random = ~ 1 | case, 
                 correlation = corAR1(0, ~ time | case), 
                 data = Laski)
Laski_g <- g_REML(Laski_RML, p_const = c(0,1), 
                  r_const = c(1,0,1), returnModel=FALSE)
CI_g(Laski_g)

Laski_HPS <- with(Laski, effect_size_MB(outcome, treatment, case, time))
CI_g(Laski_HPS)

}
