% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/checktree.R
\name{checktree}
\alias{checktree}
\title{Check the tree structure implied by a scenario tree nodal partition matrix.}
\usage{
checktree(treeStruct)
}
\arguments{
\item{treeStruct}{Matrix defining the nodal structure of the tree.}
}
\value{
Returns a plot of the scenario tree structure implied by the input nodal partition matrix.
}
\description{
Returns a plot showing the nodal structure (not values) of a scenario tree defined using a scenario tree nodal partition matrix.
}
\examples{
treeStruct <- rbind(c(1, 1, 1, 1, 1),
                    c(2, 2, 7, 7, 11),
                    c(3, 5, 8, 8, 12),
                    c(4, 6, 9, 10, 13)
                    )
checktree(treeStruct)
}
\references{
Dupacova, Jitka, Giorgio Consigli, and Stein W. Wallace. "Scenarios for multistage stochastic programs." Annals of operations research 100.1-4 (2000): 25-53.
}

