% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-spaces.R
\name{rgb_to_xyz}
\alias{rgb_to_xyz}
\title{Convert from RGB colour channels to XYZ space.}
\usage{
rgb_to_xyz(rgb, transformation = "sRGB", linear_func = NULL)
}
\arguments{
\item{rgb}{A dataframe or matrix with red, green and blue colour channels located in the columns 1 to 3, respectively. Colour channel values should be between 0 and 255, inclusive.}

\item{transformation}{An option in \code{c("sRGB", "Adobe")} for a built-in transformation or, alternatively, a custom 3x3 transformation matrix.}

\item{linear_func}{A function to convert RGB colour space into linear RGB space. Used only if a custom transformation matrix is provided. Transformation skips if no function is provided under a user-defined transformation matrix. See: https://en.wikipedia.org/wiki/SRGB.}
}
\value{
A \code{tibble} of X, Y and Z colour channels.
}
\description{
Convert from RGB colour channels to XYZ space.
}
\examples{
red <- sample(x = 1:255, size = 10, replace = TRUE)
green <- sample(x = 1:255, size = 10, replace = TRUE)
blue <- sample(x = 1:255, size = 10, replace = TRUE)
rgb_to_xyz(data.frame(r = red, g = green, b = blue), transformation = "Adobe")
}
