% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publications.r
\name{get_impactfactor}
\alias{get_impactfactor}
\title{Get journal metrics.}
\usage{
get_impactfactor(journals, max.distance = 0.05)
}
\arguments{
\item{journals}{a character list giving the journal list}

\item{max.distance}{maximum distance allowed for a match bewteen journal and journal list.
Expressed either as integer, or as a fraction of the pattern length times the maximal transformation cost
(will be replaced by the smallest integer not less than the corresponding fraction), or a list with possible components}
}
\value{
Journal metrics data.
}
\description{
Get journal metrics (impact factor) for a journal list.
}
\examples{
library(scholar)

id <- get_publications("bg0BZ-QAAAAJ&hl")
impact <- get_impactfactor(journals=id$journal, max.distance = 0.1)

id <- cbind(id, impact)

}
\author{
Dominique Makowski and Guangchuang Yu
}
