% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{fwrite}
\alias{fwrite}
\title{Fast write.table/textConnection substitute}
\usage{
fwrite(x, file = stdout(), sep = "\\t", format = paste(rep("\%s",
  ncol(x)), collapse = sep))
}
\arguments{
\item{x}{a data frame}

\item{file}{a connection or \code{return} to return character output directly (fast)}

\item{sep}{column separator}

\item{format}{optional fprint-style column format specifyer}
}
\value{
Use for the side effect of writing to the connection returning \code{NULL}, or
return a character value when \code{file=return}.
}
\description{
Conversions are vectorized and the entire output is buffered in memory and written in
one shot. Great option for replacing writing to a textConnection (much much faster).
Not such a great option for writing to files, marginal difference from write.table and
obviously much greater memory use.
}
\keyword{internal}

