% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ADFun_builders.R
\name{moretapebuilders}
\alias{moretapebuilders}
\alias{tapeJacobian}
\alias{tapeHessian}
\alias{tapeGradOffset}
\alias{tapeLogJacDet}
\alias{tapeSwap}
\title{Build New Tapes from Existing Tapes}
\usage{
tapeJacobian(tape)

tapeHessian(tape)

tapeGradOffset(tape)

tapeLogJacDet(tape)

tapeSwap(tape)
}
\arguments{
\item{tape}{An \code{\link{ADFun}} object.}
}
\value{
An \code{\link{ADFun}} object.
}
\description{
Build new tapes (i.e \code{\link{ADFun}} objects) from existing tapes, including differentiation, swapping independent variables and dynamic parameters, and Jacobian determinants.
}
\details{
The information in the fields \code{xtape} and \code{dyntape} of \code{tape} are used to perform the taping.

\subsection{tapeJacobian}{

The returned vector is ordered with the range elements iterating fastest, then the domain elements. See \url{https://cppad.readthedocs.io/latest/Jacobian.html}.
}

\subsection{tapeHessian}{

Suppose the function represented by \code{tape} maps from \eqn{d}-dimensional space to \eqn{1}-dimensional space, then
the first \eqn{d} elements of the vector is the gradient of the partial derivative with respect to the first dimension of the function's domain.
The next \eqn{d} elements of the vector is the gradient of the partial derivative of the second dimension of the function's domain.
The Hessian as a matrix, can be obtained by using \code{\link[=matrix]{matrix()}} with \code{ncol = d}.
}

\subsection{tapeGradOffset}{

A quadratic function can be written as
\deqn{f(x;\theta) = \frac{1}{2} x^T W(\theta) x + b(\theta)^Tx + c,}
where the vector \eqn{x} is the independent variable of \code{tape} and the vector \eqn{\theta} is the dynamic parameter vector of \code{tape}.
The gradient of \eqn{f(x; \theta)} with respect to \eqn{x} is
\deqn{\Delta f(x; \theta) = \frac{1}{2}(W(\theta) + W(\theta)^T)x + b(\theta).}
The Hessian is
\deqn{H f(x; \theta) = \frac{1}{2}(W(\theta) + W(\theta)^T),}
which does not depend on \eqn{x},
so the gradient of the function can be rewritten as
\deqn{\Delta f(x;\theta) = H f(x; \theta) x + b(\theta)^T.}
The tape calculates \eqn{b(\theta)} as
\deqn{b(\theta) = \Delta f(x;\theta) - H f(x; \theta) x,}
which does not depend on \eqn{x}.
}
}
\section{Functions}{
\itemize{
\item \code{tapeJacobian()}: Tape the Jacobian of a tape. The resulting tape returns the Jacobian as a vector.

\item \code{tapeHessian()}: Tape the Hessian of a tape. The resulting tape returns the Jacobian as a vector (see \url{https://cppad.readthedocs.io/latest/Hessian.html}).

\item \code{tapeGradOffset()}: A quadratic function can be written as
\deqn{f(x;\theta) = \frac{1}{2} x^T W(\theta) x + b(\theta)^Tx + c.}
The function \code{tapeGradOffset} creates a tape of \eqn{b(\theta)} where \eqn{\theta} is the independent variable.

\item \code{tapeLogJacDet()}: Creates a tape of the log of the Jacobian determinant of a function taped in \code{tape}. The dimensions of the domain (length of independent variable) and range (length of output variable) of \code{tape} must be equal for computation of the determinant.

\item \code{tapeSwap()}: Convert an ADFun so that the independent variables become dynamic parameters
and the dynamic parameters become independent variables.

}}
\examples{
tapes <- buildsmdtape("sph", "identity", "sph", "vMF",
              ytape = rep(1, 3)/sqrt(3),
              usertheta = rep(NA, 3)
              ) 
tapeJacobian(tapes$smdtape)
tapeHessian(tapes$smdtape)
tapeLogJacDet(tapeJacobian(tapes$smdtape))
tapeSwap(tapes$smdtape)
}
\seealso{
\code{\link{ADFun}}

Other tape builders: 
\code{\link{buildsmdtape}()}
}
\concept{tape builders}
