% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_t.R
\name{scores_t}
\alias{scores_t}
\alias{crps_t}
\alias{crps_ct}
\alias{crps_tt}
\alias{crps_gtct}
\alias{logs_t}
\alias{logs_tt}
\alias{dss_t}
\alias{gradcrps_t}
\alias{gradcrps_ct}
\alias{gradcrps_tt}
\alias{hesscrps_t}
\alias{hesscrps_ct}
\alias{hesscrps_tt}
\title{Calculating scores for Student's \eqn{t}-distribution}
\usage{
## score functions
crps_t(y, df, location = 0, scale = 1)
crps_ct(y, df, location = 0, scale = 1, lower = -Inf, upper = Inf)
crps_tt(y, df, location = 0, scale = 1, lower = -Inf, upper = Inf)
crps_gtct(y, df, location = 0, scale = 1, lower = -Inf, upper = Inf, lmass = 0, umass = 0)
logs_t(y, df, location = 0, scale = 1)
logs_tt(y, df, location = 0, scale = 1, lower = -Inf, upper = Inf)
dss_t(y, df, location = 0, scale = 1)

## gradient (location, scale) functions
gradcrps_t(y, df, location = 0, scale = 1)
gradcrps_ct(y, df, location = 0, scale = 1, lower = -Inf, upper = Inf)
gradcrps_tt(y, df, location = 0, scale = 1, lower = -Inf, upper = Inf)

## Hessian (location, scale) functions
hesscrps_t(y, df, location = 0, scale = 1)
hesscrps_ct(y, df, location = 0, scale = 1, lower = -Inf, upper = Inf)
hesscrps_tt(y, df, location = 0, scale = 1, lower = -Inf, upper = Inf)
}
\arguments{
\item{y}{vector of observations.}

\item{df}{vector of degrees of freedom.}

\item{location}{vector of location parameters.}

\item{scale}{vector of scale paramters.}

\item{lower, upper}{lower and upper truncation/censoring bounds.}

\item{lmass, umass}{vectors of point masses in \code{lower} and \code{upper}
respectively.}
}
\value{
For the CRPS functions: a vector of score values.

For the gradient and Hessian functions: a matrix with column names
corresponding to the respective partial derivatives.
}
\description{
These functions calculate scores (CRPS, logarithmic score) and their gradient and Hessian with respect
to the parameters of a location-scale transformed Student's
\eqn{t}-distribution. Furthermore, the censoring transformation and
the truncation transformation may be introduced on top of the
location-scale transformed normal distribution.
}
