% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_forecasts.R
\name{eval_forecasts}
\alias{eval_forecasts}
\title{Evaluate forecasts}
\usage{
eval_forecasts(data, summarised = TRUE)
}
\arguments{
\item{data}{A data.frame or data.table with the following columns:
\itemize{
  \item \code{true_values} the true observed values
  \item \code{id} A unique identifier of the true values. Could be a date
  or just a running index
  \item \code{predictions} predictions or predictive samples for one
  true value. Not necessary in case of quantile forecasts
  \item \code{model} name of the model that generated the predictions
  \item \code{sample} an index to identify the predictive samples in the
  predictiions column generated by one model for one true value. Only
  necessary for continuous and integer forecasts, not for quantile or
  binary predictions.
  \item {quantile forecasts} a number of pairs of columns with
  quantile predictions for a certain range. For a 50% interval
  (corresponding to the 25% and
  75% quantile), one column has to be named \code{lower_50} and one
  \code{upper_50}.
  For the median, there has to a column \code{lower_0} and one
  \code{upper_0}
  }}

\item{summarised}{if \code{TRUE}, only one average score is returned per model}
}
\value{
A data.table with appropriate scores. For binary predictions,
the Brier Score will be returned, for quantile predictions the interval
score. For integer forecasts, Sharpness, Bias, DSS, CRPS, LogS, and
pit_p_val (as an indicator of calibration) are returned. For integer
forecasts, pit_sd is returned (to account for the randomised PIT),
but no Log Score is returned (the internal estimation relies on a
kernel density estimate which is difficult for integer-valued forecasts).
If \code{summarised = TRUE} the average score per model is returned.
}
\description{
The function \code{eval_forecasts} is an easy to use wrapper
of the lower level functions in the \code{scoringutils} package.
It can be used to score probabilistic or quantile forecasts of
continuous, integer-valued or binary variables.
}
\details{
the following metrics are used where appropriate:
\itemize{
  \item {Interval Score} for quantile forecasts. Smaller is better. See
  \code{\link{interval_score}} for more information.
  \item {Brier Score} for a probability forecast of a binary outcome.
  Smaller is better. See \code{\link{brier_score}} for more information.
  \item {Bias} 0 is good, 1 and -1 are bad.
  See \code{\link{bias}} for more information.
  \item {Sharpness} Smaller is better. See \code{\link{sharpness}} for more
  information.
  \item {Calibration} represented through the p-value of the
  Anderson-Darling test for the uniformity of the Probability Integral
  Transformation (PIT). For integer valued forecasts, this p-value also
  has a standard deviation. Larger is better.
  See \code{\link{pit}} for more information.
  \item {DSS} Dawid-Sebastiani-Score. Smaller is better.
  See \code{\link{dss}} for more information.
  \item {CRPS} Continuous Ranked Probability Score. Smaller is better.
  See \code{\link{crps}} for more information.
  \item {LogS} Log Score. Smaller is better. Only for continuous forecasts.
  See \code{\link{logs}} for more information.
}
}
\examples{
## Probability Forecast for Binary Target
binary_example <- data.table::setDT(scoringutils::binary_example_data)
eval <- scoringutils::eval_forecasts(binary_example)
eval <- scoringutils::eval_forecasts(binary_example, summarised = FALSE)

## Quantile Forecasts
quantile_example <- data.table::setDT(scoringutils::quantile_example_data)
eval <- scoringutils::eval_forecasts(quantile_example)
eval <- scoringutils::eval_forecasts(quantile_example, summarised = FALSE)

## Integer Forecasts
integer_example <- data.table::setDT(scoringutils::integer_example_data)
eval <- scoringutils::eval_forecasts(integer_example)
eval <- scoringutils::eval_forecasts(integer_example, summarised = FALSE)

## Continuous Forecasts
continuous_example <- data.table::setDT(scoringutils::continuous_example_data)
eval <- scoringutils::eval_forecasts(continuous_example)
eval <- scoringutils::eval_forecasts(continuous_example, summarised = FALSE)

}
\references{
Funk S, Camacho A, Kucharski AJ, Lowe R, Eggo RM, Edmunds WJ
(2019) Assessing the performance of real-time epidemic forecasts: A
case study of Ebola in the Western Area region of Sierra Leone, 2014-15.
PLoS Comput Biol 15(2): e1006785.
\url{https://doi.org/10.1371/journal.pcbi.1006785}
}
\author{
Nikos Bosse \email{nikosbosse@gmail.com}
}
