% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-wis.R
\name{plot_wis}
\alias{plot_wis}
\title{Plot contributions to the weighted interval score}
\usage{
plot_wis(scores, x = "model", relative_contributions = FALSE, flip = FALSE)
}
\arguments{
\item{scores}{A data.table of scores based on quantile forecasts as
produced by \code{\link[=score]{score()}} and summarised using \code{\link[=summarise_scores]{summarise_scores()}}.}

\item{x}{The variable from the scores you want to show on the x-Axis.
Usually this will be "model".}

\item{relative_contributions}{Logical. Show relative contributions instead
of absolute contributions? Default is \code{FALSE} and this functionality is not
available yet.}

\item{flip}{Boolean (default is \code{FALSE}), whether or not to flip the axes.}
}
\value{
A ggplot object showing a contributions from the three components of
the weighted interval score.

A ggplot object with a visualisation of the WIS decomposition
}
\description{
Visualise the components of the weighted interval score: penalties for
over-prediction, under-prediction and for high dispersion (lack of
sharpness).
}
\examples{
library(ggplot2)
library(magrittr) # pipe operator
scores <- example_quantile \%>\%
  as_forecast_quantile \%>\%
  score()
scores <- summarise_scores(scores, by = c("model", "target_type"))

plot_wis(scores,
  x = "model",
  relative_contributions = TRUE
) +
  facet_wrap(~target_type)
plot_wis(scores,
  x = "model",
  relative_contributions = FALSE
) +
  facet_wrap(~target_type, scales = "free_x")
}
\references{
Bracher J, Ray E, Gneiting T, Reich, N (2020) Evaluating epidemic forecasts
in an interval format. \url{https://journals.plos.org/ploscompbiol/article?id=10.1371/journal.pcbi.1008618}
}
