% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scphaser.R
\name{filter_zerorow}
\alias{filter_zerorow}
\title{Filter variants with zero allele counts in all cells}
\usage{
filter_zerorow(acset)
}
\arguments{
\item{acset}{An acset list which must contain "refcount" and "altcount"
elements with allele counts, see \code{\link{new_acset}}.}
}
\value{
acset An acset list subsetted on variants that pass the filter.
}
\description{
\code{filter_zerorow} removes variants which do no have any read count
}
\examples{
##create small artifical allele count matrixes where first row is zero
ncells = 10
ref = c(0, 10, 1, 5, 2, 9)
alt = c(0, 2, 5, 5, 6, 3)        
refcount = as.matrix(as.data.frame(rep(list(ref, alt), ncells / 2)))
altcount = as.matrix(as.data.frame(rep(list(alt, ref), ncells / 2)))

vars = 1:nrow(refcount)
samples = 1:ncells
colnames(refcount) = samples
rownames(refcount) = vars
colnames(altcount) = samples
rownames(altcount) = vars

##create a feature annotation data-frame
nvars = length(vars)
featdata = as.data.frame(matrix(cbind(rep('jfeat', nvars),
as.character(1:nvars), rep('dummy', nvars), rep('dummy', nvars)), ncol = 4,
dimnames = list(vars, c('feat', 'var', 'ref', 'alt'))), stringsAsFactors =
FALSE)

##create acset
acset = new_acset(featdata, altcount = altcount, refcount = refcount)

##Remove variants having no allele counts
acset_filt = filter_zerorow(acset)

}

