% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round-ceil-floor.R
\name{rounding-uncommon}
\alias{rounding-uncommon}
\alias{round_ceiling}
\alias{round_floor}
\alias{round_trunc}
\alias{anti_trunc}
\alias{round_anti_trunc}
\title{Uncommon rounding procedures}
\usage{
round_ceiling(x, digits = 0L)

round_floor(x, digits = 0L)

round_trunc(x, digits = 0L)

anti_trunc(x)

round_anti_trunc(x, digits = 0L)
}
\arguments{
\item{x}{Numeric. The decimal number to round.}

\item{digits}{Integer. Number of digits to round \code{x} to. Default is \code{0}.}
}
\value{
Numeric. \code{x} rounded to \code{digits} (except for \code{anti_trunc()}, which
has no \code{digits} argument).
}
\description{
Always round up, down, toward zero, or away from it:
\itemize{
\item \code{round_ceiling()} always rounds up.
\item \code{round_floor()} always rounds down.
\item \code{round_trunc()} always rounds toward zero.
\item \code{round_anti_trunc()} always rounds away from zero. (\code{0} itself is
rounded to \code{1}.)
}

Despite not being widely used, they are featured here in case they are needed
for reconstruction.
}
\details{
\code{round_ceiling()}, \code{round_floor()}, and \code{round_trunc()} generalize
the base functions \code{ceiling()}, \code{floor()}, and \code{trunc()}, and include them
as special cases: With the default value for \code{digits}, 0, these \verb{round_*}
functions are equivalent to their respective base counterparts.

The last \verb{round_*} function, \code{round_anti_trunc()}, generalizes another
function presented here: \code{anti_trunc()} works like \code{trunc()} except it
moves away from 0, rather than towards it. That is, whereas \code{trunc()}
minimizes the absolute value of \code{x} (as compared to the other rounding
functions), \code{anti_trunc()} maximizes it. \code{anti_trunc(x)} is therefore equal
to \code{trunc(x)} \code{ + 1} if \code{x} is positive, and to \code{trunc(x) - 1} if \code{x} is
negative.

\code{round_anti_trunc()}, then, generalizes \code{anti_trunc()} just as
\code{round_ceiling()} generalizes \code{ceiling()}, etc.

Moreover, \code{round_trunc()} is equivalent to \code{round_floor()} for positive
numbers and to \code{round_ceiling()} for negative numbers. The reverse is again
true for \code{round_anti_trunc()}: It is equivalent to \code{round_ceiling()} for
positive numbers and to \code{round_floor()} for negative numbers.
}
\examples{
# Always round up:
round_ceiling(x = 4.52, digits = 1)        # 2 cut off

# Always round down:
round_floor(x = 4.67, digits = 1)          # 7 cut off

# Always round toward 0:
round_trunc(8.439, digits = 2)             # 9 cut off
round_trunc(-8.439, digits = 2)            # 9 cut off

# Always round away from 0:
round_anti_trunc(x = 8.421, digits = 2)    # 1 cut off
round_anti_trunc(x = -8.421, digits = 2)   # 1 cut off
}
\seealso{
\code{round_up()} and \code{round_down()} round up or down from 5,
respectively. \code{round_up_from()} and \code{round_down_from()} allow users to
specify custom thresholds for rounding up or down.
}
