% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_match.R
\name{hier_match}
\alias{hier_match}
\title{Match default and original node labels}
\usage{
hier_match(tree, nodes = NULL, inputs = "orig")
}
\arguments{
\item{tree}{an input derived from \code{\link[=hier_create]{hier_create()}} or
\code{\link[=hier_convert]{hier_convert()}}}

\item{nodes}{\code{NULL} or a character vector specifying either
original node names or standardized default codes. If
\code{NULL}, the information is returned for all nodes.}

\item{inputs}{(character) specifies what kind of node names are
provided in argument \code{nodes}. Allowed choices are:
\itemize{
\item \code{"orig"}: argument \code{nodes} refers to original node names
\item \code{"default"}: argument \code{nodes} refers to standardized
default codes
}}
}
\value{
a \code{data.table} with the following columns:
\itemize{
\item \code{"orig"}: the original node names
\item `"default": the standardized names
\item \code{"is_bogus"}: \code{TRUE} if the code is a \code{"bogus"} (duplicated)
node.
}
}
\description{
This function returns a \code{data.table} that maps original
and default codes.
}
\examples{
h <- hier_create(root = "Tot", nodes = letters[1:5])
h <- hier_add(h, root = "a", nodes = "a0")
h2 <- hier_convert(tree = h, as = "dt")
hier_match(tree = h, nodes = c("a", "b"), inputs = "orig")
hier_match(tree = h2, nodes = c("01", "02"), inputs = "default")
}
