% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valTable.R
\name{valTable}
\alias{valTable}
\title{Comparison of different microaggregation methods}
\usage{
valTable(
  x,
  method = c("simple", "onedims", "clustpppca", "addNoise: additive", "swappNum"),
  measure = "mean",
  clustermethod = "clara",
  aggr = 3,
  nc = 8,
  transf = "log",
  p = 15,
  noise = 15,
  w = 1:dim(x)[2],
  delta = 0.1
)
}
\arguments{
\item{x}{a \code{data.frame} or a \code{matrix}}

\item{method}{character vector defining names of microaggregation-, adding-noise
or rank swapping methods.}

\item{measure}{FUN for aggregation. Possible values are mean (default), median, trim, onestep.}

\item{clustermethod}{clustermethod, if a method will need a clustering procedure}

\item{aggr}{aggregation level (default=3)}

\item{nc}{number of clusters. Necessary, if a method will need a clustering procedure}

\item{transf}{Transformation of variables before clustering.}

\item{p}{Swapping range, if method swappNum has been chosen}

\item{noise}{noise addition, if an addNoise method has been chosen}

\item{w}{variables for swapping, if method swappNum has been chosen}

\item{delta}{parameter for adding noise method \code{"correlated2"}}
}
\value{
Measures of information loss splitted for the comparison of different methods.
}
\description{
A Function for the comparison of different perturbation methods.
}
\details{
Tabularize the output from \code{\link[=summary.micro]{summary.micro()}}. Will be enhanced to all
perturbation methods in future versions.

Methods for adding noise should be named via \code{addNoise:{method}}, e.g.
\code{addNoise:correlated}, where \code{{method}} specifies the desired method as
described in \code{\link[=addNoise]{addNoise()}}.
}
\examples{
data(Tarragona)
\dontrun{
valTable(
  x = Tarragona[100:200, ],
  method=c("simple", "onedims", "pca"))

valTable(
  x = Tarragona,
  method = c("simple", "onedims", "pca", "clustpppca", "mdav", "swappNum"))

## clustpppca in combination with Mclust outperforms
## the other algorithms for this data set...
}
}
\references{
Templ, M. and Meindl, B., \verb{Software Development for SDC in R}, Lecture Notes in Computer Science, Privacy in Statistical Databases,
vol. 4302, pp. 347-359, 2006.
}
\seealso{
\code{\link[=microaggregation]{microaggregation()}}, \code{\link[=summary.micro]{summary.micro()}}
}
\author{
Matthias Templ
}
\keyword{print}
