% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createArgusInput.R
\name{createArgusInput}
\alias{createArgusInput}
\title{Create input files for tauArgus}
\usage{
createArgusInput(
  obj,
  typ = "microdata",
  verbose = FALSE,
  path = getwd(),
  solver = "FREE",
  method,
  primSuppRules = NULL,
  responsevar = NULL,
  shadowvar = NULL,
  costvar = NULL,
  requestvar = NULL,
  holdingvar = NULL,
  ...
)
}
\arguments{
\item{obj}{an object of class \linkS4class{sdcProblem} from \code{sdcTable}}

\item{typ}{(character) either \code{"microdata"} or \code{"tabular"}}

\item{verbose}{(logical) if TRUE, the contents of the batch-file are written to the prompt}

\item{path}{path, into which (temporary) files will be written to (amongst them being the batch-files).
Each file written to this folder belonging to the same problem contains a random id in its filename.}

\item{solver}{which solver should be used. allowed choices are
\itemize{
\item \code{"FREE"}
\item \code{"CPLEX"}
\item \code{"XPRESS"}
}

In case \code{"CPLEX"} is used, it is also mandatory to specify argument \code{licensefile} which needs to be
the absolute path the the cplex license file}

\item{method}{secondary cell suppression algorithm, possible choices include:
\itemize{
\item \code{"MOD"}: modular approach. If specified, the following arguments in \code{...} can additionally be set:
\itemize{
\item \code{MaxTimePerSubtable}: number specifiying max. time (in minutes) spent for each subtable
\item \code{SingleSingle}: 0/1 (default=1)
\item \code{SingleMultiple}: 0/1 (default=1)
\item \code{MinFreq}: 0/1 (default=1)
}
\item \code{"GH"}: hypercube. If specified, the following arguments in \code{...} can additionally be set:
\itemize{
\item \code{BoundPercentage}: Default percentage to proctect primary suppressed cells, default 75
\item \code{ModelSize}: are we dealing with a small (0) or large (1) model? (default=1)
\item \code{ApplySingleton}: should singletons be additionally protected? 0/1 (default=1)
}
\item \code{"OPT"}: optimal cell suppression. If specified, the following arguments in \code{...} can additionally be set:
\itemize{
\item \code{MaxComputingTime}: number specifiying max. allowed computing time (in minutes)
}
}}

\item{primSuppRules}{rules for primary suppression, provided as a
\code{list}. For details, please have a look at the examples below.}

\item{responsevar}{which variable should be tabulated (defaults to frequencies). For details see tau-argus manual section 4.4.4.}

\item{shadowvar}{if specified, this variable is used to apply the safety rules, defaults to \code{responsevar}. For details
see tau-argus manual section 4.4.4.}

\item{costvar}{if specified, this variable describes the costs of suppressing each individual cell. For details see tau-argus
manual section 4.4.4.}

\item{requestvar}{if specified, this variable (0/1-coded) contains information about records that request protection.
Records with 1 will be protected in case a corresponding request rule matches. It is ignored, if tabular input is used.}

\item{holdingvar}{if specified, this variable contains information about records that should be grouped together.
It is ignored, if tabular input is used.}

\item{...}{allows to specify additional parameters for selected suppression-method as described above
as well as \code{licensefile} in clase \code{"CPLEX"} was specified in argument \code{solver}.}
}
\value{
the filepath to the batch-file
}
\description{
create required input-files and batch-file for tau-argus given an \linkS4class{sdcProblem} object
}
\examples{
# loading micro data from sdcTable
utils::data("microdata1", package="sdcTable")
microdata1$num1 <- rnorm(mean = 100, sd = 25, nrow(microdata1))
microdata1$num2 <- round(rnorm(mean = 500, sd=125, nrow(microdata1)),2)
microdata1$weight <- sample(10:100, nrow(microdata1), replace = TRUE)

dim_region <- hier_create(root = "Total", nodes = LETTERS[1:4])

dim_region_dupl <- hier_create(root = "Total", nodes = LETTERS[1:4])
dim_region_dupl <- hier_add(dim_region_dupl, root = "B", nodes = c("b1"))
dim_region_dupl <- hier_add(dim_region_dupl, root = "D", nodes = c("d1"))

dim_gender <- hier_create(root = "Total", nodes = c("male", "female"))

dimList <- list(region = dim_region, gender = dim_gender)
dimList_dupl  <- list(region = dim_region_dupl, gender = dim_gender)
dimVarInd <- 1:2
numVarInd <- 3:5
sampWeightInd <- 6

# creating an object of class \code{\link{sdcProblem-class}}
obj <- makeProblem(
  data = microdata1,
  dimList = dimList,
  dimVarInd = dimVarInd,
  numVarInd = numVarInd,
  sampWeightInd = sampWeightInd)

# creating an object of class \code{\link{sdcProblem-class}} containing "duplicated" codes
obj_dupl <- makeProblem(
  data = microdata1,
  dimList = dimList_dupl,
  dimVarInd = dimVarInd,
  numVarInd = numVarInd,
  sampWeightInd = sampWeightInd)

## create primary suppression rules
primSuppRules <- list()
primSuppRules[[1]] <- list(type = "freq", n = 5, rg = 20)
primSuppRules[[2]] <- list(type = "p", n = 5, p = 20)
# other supported formats are:
# list(type = "nk", n=5, k=20)
# list(type = "zero", rg = 5)
# list(type = "mis", val = 1)
# list(type = "wgt", val = 1)
# list(type = "man", val = 20)

## create batchInput object
bO_md1 <- createArgusInput(
  obj = obj,
  typ = "microdata",
  path = tempdir(),
  solver = "FREE",
  method = "OPT",
  primSuppRules = primSuppRules,
  responsevar = "num1")

bO_td1 <- createArgusInput(
  obj = obj,
  typ = "tabular",
  path = tempdir(),
  solver = "FREE",
  method = "OPT")

bO_td2 <- createArgusInput(
  obj = obj_dupl,
  typ = "tabular",
  path = tempdir(),
  solver = "FREE",
  method = "OPT")

\dontrun{
## in case CPLEX should be used, it is required to specify argument licensefile
bO_md2 <- createArgusInput(
  obj = obj,
  typ = "microdata",
  path = tempdir(),
  solver = "CPLEX",
  method = "OPT",
  primSuppRules = primSuppRules,
  responsevar = "num1",
  licensefile = "/path/to/my/cplexlicense")
}
}
