% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{kIndex}
\alias{kIndex}
\alias{ijIndex}
\alias{kColToRow}
\alias{kRowToCol}
\title{Utilities for conversion between row-column indexing and linear indexing of matrices}
\usage{
kIndex(i, j, nr, nc, byRows = FALSE)

ijIndex(k, nr, nc, byRows = FALSE)

kColToRow(k, nr, nc)

kRowToCol(k, nr, nc)
}
\arguments{
\item{i}{row index.}

\item{j}{column index.}

\item{nr}{number of rows.}

\item{nc}{number of columns.}

\item{byRows}{whether to use row-ordering instead of the default column-ordering.}

\item{k}{linear indexes for column-stacking or row-stacking ordering (if \code{byRows = TRUE}).}
}
\value{
Depending on the function:
\itemize{
\item \code{kIndex}: a vector of length \code{nr * nc} with the linear indexes for \code{A}.
\item \code{ijIndex}: a matrix of dimension \code{c(length(k), 2)} giving \code{cbind(i, j)}.
\item \code{kColToRow} and \code{kRowToCol}: a vector of length \code{nr * nc} giving the permuting indexes to change the ordering of the linear indexes.
}
}
\description{
Conversions between \code{cbind(i, j)} and \code{k} such that \code{A[i, j] == A[k]} for a matrix \code{A}. Either column or row ordering can be specified for the linear indexing, and also direct conversions between both types.
}
\examples{
# Indexes of a 3 x 5 matrix
ij <- expand.grid(i = 1:3, j = 1:5)
kCols <- kIndex(i = ij[, 1], j = ij[, 2], nr = 3, nc = 5)
kRows <- kIndex(i = ij[, 1], j = ij[, 2], nr = 3, nc = 5, byRows = TRUE)

# Checks
ijIndex(kCols, nr = 3, nc = 5)
ij
ijIndex(kRows, nr = 3, nc = 5, byRows = TRUE)
ij

# Change column to row (and viceversa) ordering in the linear indexes
matrix(1:10, nr = 2, nc = 5)
kColToRow(1:10, nr = 2, nc = 5)
kRowToCol(kColToRow(1:10, nr = 2, nc = 5), nr = 2, nc = 5)
}
\keyword{internal}
