% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_bn.R
\name{gen_bn_elicit}
\alias{gen_bn_elicit}
\title{Generate synthetic data using BN parameter learning with an elicted structure.}
\usage{
gen_bn_elicit(training_set, bn_structure, evidences = NA)
}
\arguments{
\item{training_set}{A data frame of the training data. The generated data will
have the same size as the \code{training_set}.}

\item{bn_structure}{A string of the relationships between variables from
\code{\link[bnlearn:model string utilities]{modelstring}}.}

\item{evidences}{A string of evidence that is used to constraint the sampling of the
generated data.}
}
\value{
The output is a list of three objects: i) structure: the structure of the
BN indicating the relationship between the variables (a \code{\link[bnlearn:bn class]{bn-class}}
object); ii) fit_model: the fitted model showing the parameter distributions between
the variables ((a \code{\link[bnlearn:bn.fit]{bn.fit}}) object and iii) gen_data:
the generated synthetic data - if there is evidence to constraint the values
for some of the variables, the generated synthetic data will be sampled accroding
to the criteria.
}
\description{
\code{gen_bn_elicit} uses Bayesian parameter learning (Maximum Likelihood
Estimation, MLE) to learn the values of the parameters based on the given
dependencies of the variables and the input data.
}
\examples{
adult_data <- split_data(adult[1:100,], 70)
bn_evidence <- "age >=18 & capital_gain>=0 & capital_loss >=0 &
               hours_per_week>=0 & hours_per_week<=100"
bn_structure <- "[native_country][income][age|marital_status:education]"
bn_structure = paste0(bn_structure, "[sex][race|native_country][marital_status|race:sex]")
bn_structure = paste0(bn_structure,"[relationship|marital_status][education|sex:race]")
bn_structure = paste0(bn_structure,"[occupation|education][workclass|occupation]")
bn_structure = paste0(bn_structure,"[hours_per_week|occupation:workclass]")
bn_structure = paste0(bn_structure,"[capital_gain|occupation:workclass:income]")
bn_structure = paste0(bn_structure,"[capital_loss|occupation:workclass:income]")
bn_elicit <- gen_bn_elicit(adult_data$training_set, bn_structure, bn_evidence)

}
