% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minelips.R
\name{minelips}
\alias{minelips}
\title{The Minimum Ellipsoid Problem}
\usage{
minelips(V)
}
\arguments{
\item{V}{An nxp matrix consisting of the points to be contained in the ellipsoid}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant c matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{minelips} creates input for sqlp to solve the minimum ellipsoid problem -
given a set of n points, find the minimum volume ellipsoid that contains all the points
}
\details{
for a set of points (x1,...,xn) determines the ellipse of minimum volume that contains all points.
Mathematical and implementation details can be found in the vignette
}
\examples{
data(Vminelips)

out <- minelips(Vminelips)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b
OPTIONS <- out$OPTIONS

}

