% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct.R
\name{assert_ct_spec}
\alias{assert_ct_spec}
\title{Assert a controlled terminology specification}
\usage{
assert_ct_spec(ct_spec, optional = FALSE)
}
\arguments{
\item{ct_spec}{A data frame to be asserted as a valid controlled terminology data
set.}
}
\value{
The function throws an error if \code{ct_spec} is not a valid controlled
terminology data set; otherwise, \code{ct_spec} is returned invisibly.
}
\description{
\code{\link[=assert_ct_spec]{assert_ct_spec()}} will check whether \code{ct_spec} is a data frame and if it contains the
variables: codelist_code, collected_value, term_synonyms, and term_value.

In addition, it will also check if the data frame is not empty (no rows), and
whether the columns \code{codelist_code} and \code{term_value} do
not contain any \code{NA} values.
}
\keyword{internal}
