% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord_radar.R
\name{coord_radar}
\alias{coord_radar}
\title{Radar coordinate system}
\usage{
coord_radar(theta = "x", start = 0, direction = 1, ...)
}
\arguments{
\item{theta}{variable to map angle to (\code{x} or \code{y})}

\item{start}{Offset of starting point from 12 o'clock in radians. Offset
is applied clockwise or anticlockwise depending on value of \code{direction}.}

\item{direction}{1, clockwise; -1, anticlockwise}

\item{...}{Other arguments to be passed to \code{ggproto}.}
}
\description{
Add a radar coordinate system useful for radar charts.
}
\examples{
# Create a radar/spider chart with ggplot:
if (require("poorman") && require("tidyr") && require("ggplot2")) {
  data <- iris \%>\%
    group_by(Species) \%>\%
    summarise(across(everything(), mean)) \%>\%
    pivot_longer(-Species)

  data \%>\%
    ggplot(aes(x = name, y = value, color = Species, group = Species)) +
    geom_polygon(fill = NA, size = 2) +
    coord_radar(start = -pi / 4)
}
}
