% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.p_function.R
\name{plot.see_p_function}
\alias{plot.see_p_function}
\title{Plot method for plotting p-functions (aka consonance functions)}
\usage{
\method{plot}{see_p_function}(
  x,
  colors = c("black", "#1b6ca8"),
  size_point = 1.2,
  size_line = c(0.7, 0.9),
  size_text = 3,
  line_alpha = 0.15,
  show_labels = TRUE,
  n_columns = NULL,
  show_intercept = FALSE,
  ...
)
}
\arguments{
\item{x}{An object returned by \code{parameters::p_function ()}.}

\item{colors}{Character vector of length two, indicating the colors (in
hex-format) used when only one parameter is plotted, resp. when panels
are plotted as facets.}

\item{size_point}{Numeric specifying size of point-geoms.}

\item{size_line}{Numeric value specifying size of line geoms.}

\item{size_text}{Numeric value specifying size of text labels.}

\item{line_alpha}{Numeric value specifying alpha of lines indicating the
emphasized compatibility interval levels (see \code{?parameters::p_function}).}

\item{show_labels}{Logical. If \code{TRUE}, text labels are displayed.}

\item{n_columns}{For models with multiple components (like fixed and random,
count and zero-inflated), defines the number of columns for the
panel-layout. If \code{NULL}, a single, integrated plot is shown.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the
intercept-parameter has a posterior distribution on a very different
location, so density curves of posterior distributions for other parameters
are hardly visible.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{parameters::p_function ()}.
}
\examples{
library(parameters)
model <- lm(Sepal.Length ~ Species + Sepal.Width + Petal.Length, data = iris)
result <- p_function(model)
plot(result, n_columns = 2, show_labels = FALSE)

result <- p_function(model, keep = "Sepal.Width")
plot(result)
}
