% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.computation.R
\name{d.computation}
\alias{d.computation}
\title{Compute Cohen's d}
\usage{
d.computation(y, group, short = TRUE, target.group = NULL)
}
\arguments{
\item{y}{The y variable (quantitative) on which group differences are to be assessed.}

\item{group}{The grouping variable}

\item{short}{Logical. If true, it will only output the value of d. Otherwise, it also outputs the mean differences, the pooled variance, and
the pair of means.}

\item{target.group}{The group to reference.}
}
\value{
If \code{short=FALSE}, the mean differences, the pooled variance, and
the pair of means. Otherwise, just the d.
}
\description{
Compute Cohen's d
}
\details{
Cohen's d is used to assess average group differences, regardless of sample size. It is consequently a measure of effect size.
}
\examples{
data(iris)
d.computation(iris$Petal.Width, iris$Species, short=FALSE)
}
\author{
Dustin Fife
}

