% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/children.R
\name{elem_ancestors}
\alias{elem_ancestors}
\alias{elem_parent}
\alias{elem_siblings}
\alias{elem_children}
\alias{elem_descendants}
\title{Get the DOM family of an element}
\usage{
elem_ancestors(x)

elem_parent(x)

elem_siblings(x)

elem_children(x)

elem_descendants(x)
}
\arguments{
\item{x}{A \code{selenider_element} object.}
}
\value{
All functions return a \code{selenider_elements} object, except
\code{elem_parent()}, which returns a \code{selenider_element} object (since an
element can only have one parent).
}
\description{
Find all elements with a certain relative position to an HTML element.

\code{elem_ancestors()} selects every element which contains the current element
(children, grand-children, etc.).

\code{elem_parent()} selects the element that contains the current element.

\code{elem_siblings()} selects every element which has the same parent as the
current element.

\code{elem_children()} selects every element which is connected to and directly
below the current element.

\code{elem_descendants()} selects every element that is contained by the current
element. The current element does not have to be a direct parent, but must
be some type of ancestor.
}
\details{
All functions except \code{elem_children()} and \code{elem_descendants()} use XPath
selectors, so may be slow, especially when using \code{chromote} as a backend.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<html>
<body>
  <div>
    <div id='current'>
      <p></p>
      <div>
        <p></p>
        <br>
      </div>
    </div>
    <div></div>
    <p></p>
  </div>
</body>
</html>
"

session <- minimal_selenider_session(html)

current <- s("#current")

# Get all the names of an element collection
elem_names <- function(x) {
  x |>
    as.list() |>
    vapply(elem_name, FUN.VALUE = character(1))
}

current |>
  elem_ancestors() |>
  elem_expect(has_length(3)) |>
  elem_names() # html, div, body

current |>
  elem_parent() |>
  elem_name() # div

current |>
  elem_siblings() |>
  elem_expect(has_length(2)) |>
  elem_names() # div, p

current |>
  elem_children() |>
  elem_expect(has_length(2)) |>
  elem_names() # p, div

current |>
  elem_descendants() |>
  elem_expect(has_length(4)) |>
  elem_names() # p, div, p, br

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \url{http://web.simmons.edu/~grovesd/comm244/notes/week4/document-tree} for a
simple and visual explanation of the document tree.
\item \code{\link[=find_element]{find_element()}} and \code{\link[=find_elements]{find_elements()}} for other ways of selecting
elements. These functions allow you to select ancestors using one or more
conditions (e.g. CSS selectors).
\item \code{\link[=elem_filter]{elem_filter()}} and \code{\link[=elem_find]{elem_find()}} for filtering element collections.
}
}
