% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_actions.R
\name{back}
\alias{back}
\alias{forward}
\title{Move back or forward in browsing history}
\usage{
back(session = NULL)

forward(session = NULL)
}
\arguments{
\item{session}{A \code{selenider_session} object. If not specified, the global
session object (the result of \code{\link[=get_session]{get_session()}}) is used.}
}
\value{
The session object, invisibly.
}
\description{
\code{back()} navigates to the previously opened URL, or the previously opened
page in your browsing history.

\code{forward()} reverses the action of \code{back()}, going to the next page in your
browsing history.
}
\examples{
\dontshow{if (selenider::selenider_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
session <- selenider_session()

open_url("https://r-project.org")

open_url("https://www.tidyverse.org/")

back()

forward()
\dontshow{\}) # examplesIf}
}
\seealso{
Other global actions: 
\code{\link{current_url}()},
\code{\link{execute_js_fn}()},
\code{\link{get_page_source}()},
\code{\link{open_url}()},
\code{\link{reload}()},
\code{\link{take_screenshot}()}
}
\concept{global actions}
