% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{elem_size}
\alias{elem_size}
\alias{length.selenider_elements}
\title{Get the number of elements in a collection}
\usage{
elem_size(x, timeout = NULL)

\method{length}{selenider_elements}(x)
}
\arguments{
\item{x}{A \code{selenider_elements} object.}

\item{timeout}{The time to wait for the parent of \code{x} (if any) to exist.}
}
\value{
An integer representing the number of elements in the collection.
}
\description{
Get the number of elements in a HTML element collection, waiting for the
parent elements (if any) to exist before returning a value.

\code{length()} and \code{elem_size()} can be used interchangeably, the only
difference being that \code{elem_size()} allows you to specify a timeout.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<div></div>
<div></div>
<div></div>
<div></div>
"
session <- minimal_selenider_session(html)

ss("div") |>
  length()
\dontshow{\}) # examplesIf}
}
\seealso{
Other properties: 
\code{\link{elem_attr}()},
\code{\link{elem_css_property}()},
\code{\link{elem_name}()},
\code{\link{elem_text}()}
}
\concept{properties}
