% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elementRetrieval.R, R/elementRetrievalDoc.R
\name{findElements}
\alias{findElements}
\title{Search for multiple elements on the page}
\usage{
findElements(remDr, using = c("xpath", "css selector", "id", "name",
  "tag name", "class name", "link text", "partial link text"), value, ...)
}
\arguments{
\item{remDr}{An object of class "rDriver". A remote driver object see \code{\link{remoteDr}}.}

\item{using}{Locator scheme to use to search the element, available schemes: {"class name", "css selector", "id", "name", "link text", "partial link text", "tag name", "xpath" }. Defaults to 'xpath'. Partial string matching is accepted.}

\item{value}{The search target. See examples.}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
invisible(lapply(res$value, wbElement, remDr = remDr)): A list of objects of class "wElement" is invisibly returned.
   A webElement object see \code{\link{wbElement}}. This allows for chaining from this function to
   other functions that take such an object as an argument. See examples for further details.
}
\description{
\code{findElements} Search for multiple elements on the page, starting from the document root. The located elements will be returned as a list of objects of class wElement.
}
\details{
Details of possible locator schemes
  \describe{
    \item{"class name" :}{Returns an element whose class name contains the search value; compound class names are not permitted.}
                                            \item{"css selector" :}{Returns an element matching a CSS selector.}
                                            \item{"id" :}{Returns an element whose ID attribute matches the search value.}
                                            \item{"name" :}{Returns an element whose NAME attribute matches the search value.}
                                            \item{"link text" :}{Returns an anchor element whose visible text matches the search value.}
                                            \item{"partial link text" :}{Returns an anchor element whose visible text partially matches the search value.}
                                            \item{"tag name" :}{Returns an element whose tag name matches the search value.}
                                            \item{"xpath" :}{Returns an element matching an XPath expression.}
                                          }
}
\examples{
\dontrun{
  remDr <- remoteDr()
  remDr \%>\% go("http://www.google.com/ncr")

  # find the search form query box and search for "R project"
  webElem <- remDr \%>\% findElement("name", "q") \%>\%
    elementSendKeys("R project", key = "enter")
  # click the first link hopefully should be www.r-project.org
  remDr \%>\% findElement("css", "h3.r a") \%>\% elementClick

  # get the navigation div
  navElem <- remDr \%>\% findElement("css", "div[role='navigation']")

  # find all the links in this div
  navLinks <- navElem \%>\% findElementsFromElement("css", "a")

  # check the links
  nLinks <- sapply(navLinks, function(x) x \%>\% getElementText)

  # compare with all links
  allLinks <- remDr \%>\% findElements("css", "a")
  aLinks <- sapply(allLinks, function(x) x \%>\% getElementText)

  # show the effect of searching for elements from element
  aLinks \%in\% nLinks

  remDr \%>\% deleteSession
}

}
\seealso{
Other elementRetrieval functions: \code{\link{findElementFromElement}},
  \code{\link{findElementsFromElement}},
  \code{\link{findElement}}, \code{\link{getActiveElement}}
}

