% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/selfea.R
\name{get_statistics_from_file}
\alias{get_statistics_from_file}
\title{get_statistics_from_file}
\usage{
get_statistics_from_file(file_expr = "", file_group = "", padj = "fdr")
}
\arguments{
\item{file_expr}{a CSV type file, comma (,) seperated file format, that has unique "ID" at the first column and expression data for the corresponding ID.  Here is an short example.
   \tabular{l}{
   ID,Y500U100_001,Y500U100_002,Y500U200_001,Y500U200_002 \cr
   YKL060C,151,195,221,201 \cr
   YDR155C,154,244,190,187 \cr
   YOL086C,64,89,116,119 \cr
   }}

\item{file_group}{a CSV type file, comma (,) seperated file format, that consists of "Col_Name", column names of "file_expr" parameter, and "Group" information of the corresponding column name.
   The order of "Col_Name" column have to be same to order of columns in "file_expr".  Here is an example.  See also the example above.
   \tabular{l}{
   Col_Name,Group \cr
   Y500U100_001,U100 \cr
   Y500U100_002,U100 \cr
   Y500U200_001,U200 \cr
   Y500U200_002,U200 \cr
   }}

\item{padj}{Choose one of these c("holm", "hochberg", "hommel", "bonferroni", "BH", "BY", "fdr", "none").
"fdr" is default option. The option is same to \code{\link[stats]{p.adjust}}.}
}
\value{
A list that consists of the following items:
   \tabular{ll}{
   $data_table \tab A data frame that have statistics for each IDs\cr
   $min_rep \tab Common number of replicates in your group information. \cr
   $max_rep \tab Maximum number of replicates in your group information. \cr
   $nt \tab The number of total experiments in your expression profile. \cr
   $ng \tab The number of groups in your group information. \cr
   $method_pvalue_adjustment \tab The selected method for p-value adjustment \cr
   }
   \tabular{ll}{
   data_table's elements \tab  \cr
   Cohens_W \tab Cohen's w \cr
   Cohens_F \tab Cohen's f\cr
   Cohens_F2 \tab Cohen's f2\cr
   Max_FC \tab Maximum fold change among all the possible group pairs\cr
   QP_Pval_adjusted \tab Adjusted p-value from GLM quasi-Poisson \cr
   NB_Pval_adjusted \tab Adjusted p-value from GLM negative binomial \cr
   Normal_Pval_adjusted \tab Adjusted p-value from Normal ANOVA \cr
   }
}
\description{
This function computes Cohen's f, f2 and w, adjusted p-value from GLM quasi-Poisson, negative binomial and Normal distribution.
}
\examples{
library(selfea)

## For this example we will import Gregori data
## Josep Gregori, Laura Villareal, Alex Sanchez, Jose Baselga, Josep Villanueva (2013).
## An Effect Size Filter Improves the Reproducibility
## in Spectral Counting-based Comparative Proteomics.
## Journal of Proteomics, DOI http://dx.doi.org/10.1016/j.jprot.2013.05.030')

## Description:
## Each sample consists in 500ng of standard yeast lisate spiked with
## 100, 200, 400 and 600fm of a mix of 48 equimolar human proteins (UPS1, Sigma-Aldrich).
## The dataset contains a different number of technical replimessagees of each sample

## Import Gregori data
data(example_data1)
df_contrast <- example_data
df_group <- example_group

## Write Gregori data to use 'get_statistics_from_file' function
write.csv(df_contrast,"expression.csv",row.names=FALSE)
write.csv(df_group,"group.csv",row.names=FALSE)

## Get statistics
list_result <- get_statistics_from_file("expression.csv","group.csv","fdr")

## Get significant features (alpha >= 0.05 and power >= 0.90)
significant_qpf <- top_table(list_result,pvalue=0.05,power_desired=0.90,method='QPF')
}

