% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compromise.R
\name{semPower.compromise}
\alias{semPower.compromise}
\title{semPower.compromise}
\usage{
semPower.compromise(
  effect = NULL,
  effect.measure = NULL,
  abratio = 1,
  N,
  df = NULL,
  p = NULL,
  SigmaHat = NULL,
  Sigma = NULL,
  muHat = NULL,
  mu = NULL,
  fittingFunction = "ML",
  ...
)
}
\arguments{
\item{effect}{effect size specifying the discrepancy between the null hypothesis (H0) and the alternative hypothesis (H1). A list for multiple group models; a vector of length 2 for effect-size differences. Can be \code{NULL} if \code{Sigma} and \code{SigmaHat} are set.}

\item{effect.measure}{type of effect, one of \code{"F0"}, \code{"RMSEA"}, \code{"Mc"}, \code{"GFI"}, \code{"AGFI"}. Can be \code{NULL} if \code{Sigma} and \code{SigmaHat} are set.}

\item{abratio}{the ratio of alpha to beta}

\item{N}{the number of observations  (a list for multiple group models)}

\item{df}{the model degrees of freedom. See \code{\link[=semPower.getDf]{semPower.getDf()}} for a way to obtain the df of a specific model.}

\item{p}{the number of observed variables, only required for \code{effect.measure = "GFI"} and \code{effect.measure = "AGFI"}.}

\item{SigmaHat}{can be used instead of \code{effect} and \code{effect.measure}: model implied covariance matrix (a list for multiple group models). Used in conjunction with \code{Sigma} to define the effect.}

\item{Sigma}{can be used instead of \code{effect} and \code{effect.measure}: population covariance matrix (a list for multiple group models). Used in conjunction with \code{SigmaHat} to define effect.}

\item{muHat}{can be used instead of \code{effect} and \code{effect.measure}: model implied mean vector. Used in conjunction with \code{mu}. If \code{NULL}, no meanstructure is involved.}

\item{mu}{can be used instead of \code{effect} and \code{effect.measure}: observed (or population) mean vector. Use in conjunction with \code{muHat}. If \code{NULL}, no meanstructure is involved.}

\item{fittingFunction}{one of \code{'ML'} (default), \code{'WLS'}, \code{'DWLS'}, \code{'ULS'}. Defines the discrepancy function used to obtain Fmin.}

\item{...}{other parameters related to plots, notably \code{plotShow}, \code{plotShowLabels}, and \code{plotLinewidth}.}
}
\value{
Returns a list. Use \code{summary()} to obtain formatted results.
}
\description{
Performs a compromise power analysis, i. e., determines the critical chi-square along with the implied alpha error and beta error , given the alpha/beta ratio, a measure of effect, N, and df
}
\examples{
\dontrun{

# determine the critical value such that alpha = beta when distinguishing a model
# involving 200 df exhibiting an RMSEA >= .08 from a perfectly fitting model.  
cp <- semPower.compromise(effect = .08, effect.measure = "RMSEA", 
                          abratio = 1, N = 250, df = 200)
summary(cp)

}
}
\seealso{
\code{\link[=semPower.aPriori]{semPower.aPriori()}} \code{\link[=semPower.postHoc]{semPower.postHoc()}}
}
