% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semmcci-mc-std.R
\name{MCStd}
\alias{MCStd}
\title{Standardized Monte Carlo Confidence Intervals}
\usage{
MCStd(object, alpha = c(0.001, 0.01, 0.05))
}
\arguments{
\item{object}{object of class \code{semmcci}.
Output of the \code{MC()} function.}

\item{alpha}{Numeric vector.
Significance level.
Default value is \code{alpha = c(0.001, 0.01, 0.05)}.}
}
\value{
Returns an object of class \code{semmcci_std}
which is a list with the following elements:
\itemize{
\item{\code{lavaan}}{\code{lavaan} object.}
\item{\code{mu}}{Mean vector used in the Monte Carlo simulation.}
\item{\code{Sigma}}{Variance-covariance matrix used in the Monte Carlo simulation.}
\item{\code{thetahat}}{Parameter estimates.}
\item{\code{thetahatstar}}{Sampling distribution of parameter estimates.}
\item{\code{ci}}{Confidence intervals.}
\item{\code{thetahat.std}}{Standardized parameter estimates.}
\item{\code{thetahatstar.std}}{Standardized sampling distribution of parameter estimates.}
\item{\code{ci.std}}{Standardized confidence intervals.}
}
The list element \code{ci.std} is a matrix with the following columns:
\itemize{
\item{\code{est}}{Standardized parameter estimates.}
\item{\code{se}}{Standard errors or the square root of the diagonals of the standardized Monte Carlo sampling distribution of parameter estimates.}
\item{\code{R}}{Number of Monte Carlo replications.}
\item{...}{Percentiles that correspond to the confidence intervals defined by \code{alpha}.}
}
Note that the rows in \code{ci.std} correspond to the standardized model parameters.
Parameters with zero standard errors and constant confidence limits are fixed parameters.
}
\description{
Calculates standardized Monte Carlo confidence intervals
for free and defined parameters.
}
\details{
The empirical sampling distribution
of parameter estimates from the argument \code{object} is standardized,
that is, each randomly generated vector of parameters is standardized.
Confidence intervals are generated
using the standardized empirical sampling distribution.
}
\examples{
library(semmcci)
library(lavaan)

# Generate Data ------------------------------------------------------------
n <- 1000
x <- rnorm(n = n)
m <- 0.50 * x + rnorm(n = n)
y <- 0.25 * x + 0.50 * m + rnorm(n = n)
data <- data.frame(x, m, y)

# Fit Model in lavaan ------------------------------------------------------
model <- "
  y ~ cp * x + b * m
  m ~ a * x
  ab := a * b
"
fit <- sem(data = data, model = model, fixed.x = FALSE)

# Monte Carlo --------------------------------------------------------------
output <- MC(
  fit,
  R = 100L, # use a large value e.g., 20000L for actual research
  alpha = c(0.001, 0.01, 0.05)
)

# Standardized Monte Carlo -------------------------------------------------
MCStd(output)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{mc}
