% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event.R
\name{event}
\alias{event}
\alias{semnar_event}
\title{Create a \code{\link{semnar_event}} object with event details}
\usage{
event(
  event = NA,
  country = NA,
  city = NA,
  state = NA,
  lon = NA,
  lat = NA,
  link = NA,
  institution = NA,
  department = NA,
  school = NA,
  venue = NA,
  address = NA,
  postcode = NA
)
}
\arguments{
\item{event}{either \code{NA} (default) or a character string with the
name of the event at which the presentation is/was given or an
object of class \code{\link{semnar_event}}. In the latter case, all input
to \code{country}, \code{city}, \code{state}, \code{lon}, \code{lat}, \code{link},
\code{institution}, \code{department}, \code{school}, \code{venue}, \code{address},
\code{postcode} is ignored and populated according to the supplied
object.}

\item{country}{country where the presentation took place; character
string or \code{NA} (default).}

\item{city}{city where the presentation took place; character
string or \code{NA} (default).}

\item{state}{state where the presentation took place; character
string or \code{NA} (default).}

\item{lon}{longitude of the venue of the presentation; numeric or
\code{NA} (default).}

\item{lat}{latitude of the venue of the presentation; numeric or
\code{NA} (default).}

\item{link}{link to the event or seminar/talk page; character
string or \code{NA} (default).}

\item{institution}{institution at which the event or seminar/talk
page took/will take space; character string or \code{NA} (default).}

\item{department}{department at which the event or seminar/talk
page took/will take space; character string or \code{NA} (default).}

\item{school}{school at which the event or seminar/talk page
took/will take space; character string or \code{NA} (default).}

\item{venue}{venue at which the event or seminar/talk page
took/will take space; character string or \code{NA} (default).}

\item{address}{address where the seminar/talk took place; character
string or \code{NA} (default).}

\item{postcode}{post code where the seminar/talk took place;
character string or \code{NA} (default).}
}
\value{
A structured \code{\link[=data.frame]{data.frame()}} that also inherits from class \code{\link{semnar_event}}, including the supplied event details.
}
\description{
Create a \code{\link{semnar_event}} object with event details
}
\examples{
# A past talk of mine
IK_warwick <- presenter(name = "Ioannis",
                       surname = "Kosmidis",
                       affiliation = "University of Warwick",
                       link = "https://www.ikosmidis.com")

YRM <- event(event = "Young Researchers' Meeting",
             country = "England",
             city = "Coventry",
             state = "NA",
             lon = -1.560843, lat = 52.384019,
             link = "https://warwick.ac.uk/fac/sci/statistics/news/yrm/",
             institution = "University of Warwick",
             department = "Department of Statistics",
             school = NA,
             venue = "Mathemtical Sciences Building",
             address = NA,
             postcode = NA)

out <- add_presentation(event = YRM,
                        presenter = IK_warwick,
                        title = "A workflow that most probably isn't yours",
                        type = "presentation",
                        start = "20190528 16:00", end = "20190528 17:00")
}
\seealso{
\code{\link[=get_event]{get_event()}} \code{\link[=set_event]{set_event()}} \code{\link[=presenter]{presenter()}} \code{\link[=get_presenter]{get_presenter()}} \code{\link[=set_presenter]{set_presenter()}}
}
