% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stripTree.R
\name{strip}
\alias{strip}
\title{Retain only basic tree structure}
\usage{
strip(x, parameters = NULL)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{parameters}{Character vector, referencing parameters in the SEM model.
Defaults to \code{NULL}, in which case all free model parameters are
returned.}
}
\value{
List
}
\description{
Removes all elements of a \code{semforest} or \code{semtree}
except for the tree structure and terminal node parameters. This is to
reduce the heavy memory footprint of sem trees and forests.
}
\details{
Objects of class \code{semforest} and \code{semtree} are very
large, which complicates downstream operations such as making partial
dependence plots, or using the model in interactive contexts (like Shiny
apps). Running \code{strip} removes all elements of the model
except for the tree structure and terminal node parameters. Note that some
methods are no longer available for the resulting object - e.g.,
\code{\link{varimp}} requires the terminal node SEM models to compute the
likelihood ratio.
}
\examples{
\dontrun{
if(interactive()){
 #EXAMPLE1
 }
}
}
