% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_merge.R
\name{s2_merge}
\alias{s2_merge}
\title{Merge S2 tiles with the same date and orbit}
\usage{
s2_merge(
  infiles,
  outdir = ".",
  subdirs = NA,
  tmpdir = NA,
  rmtmp = TRUE,
  format = NA,
  compress = "DEFLATE",
  bigtiff = FALSE,
  vrt_rel_paths = NA,
  out_crs = NA,
  parallel = FALSE,
  overwrite = FALSE,
  .log_message = NA,
  .log_output = NA
)
}
\arguments{
\item{infiles}{A vector of input filenames. Input files are paths
of products already converted from SAFE format to a format managed by
GDAL (use \link{s2_translate} to do it); their names must be in the
sen2r naming convention (\link{safe_shortname}).}

\item{outdir}{(optional) Full name of the output directory where
the files should be created (default: current directory).
\code{outdir} can bot be an existing or non-existing directory (in the
second case, its parent directory must exists).
If it is a relative path, it is expanded from the common parent
directory of \code{infiles}.}

\item{subdirs}{(optional) Logical: if TRUE, different output products are
placed in separated \code{outfile} subdirectories; if FALSE, they are placed in
\code{outfile} directory; if NA (default), subdirectories are created only if
\code{infiles} relate to more than a single product.}

\item{tmpdir}{(optional) Path where intermediate files (VRT) will be created.
Default is a temporary directory.
If \code{tmpdir} is a non-empty folder, a random subdirectory will be used.}

\item{rmtmp}{(optional) Logical: should temporary files be removed?
(Default: TRUE).
This parameter takes effect only if the output files are not VRT
(in this case temporary files cannot be deleted, because rasters of source
bands are included within them).}

\item{format}{(optional) Format of the output file (in a
format recognised by GDAL). Default is to maintain each input format.}

\item{compress}{(optional) In the case a GTiff format is
present, the compression indicated with this parameter is used.}

\item{bigtiff}{(optional) Logical: if TRUE, the creation of a BigTIFF is
forced (default is FALSE).
This option is used only in the case a GTiff format was chosen.}

\item{vrt_rel_paths}{(optional) Logical: if TRUE (default on Linux),
the paths present in the VRT output file are relative to the VRT position;
if FALSE (default on Windows), they are absolute.
This takes effect only with \code{format = "VRT"}.}

\item{out_crs}{(optional) output CRS, in any format accepted by \link{st_crs2}
(default: the CRS of the first input file). The tiles with CRS different
from \code{out_crs} will be reprojected (and a warning returned).}

\item{parallel}{(optional) Logical: if TRUE, the function is run using parallel
processing, to speed-up the computation for large rasters.
The number of cores is automatically determined; specifying it is also
possible (e.g. \code{parallel = 4}).
If FALSE (default), single core processing is used.}

\item{overwrite}{Logical value: should existing output files be
overwritten? (default: FALSE)}

\item{.log_message}{(optional) Internal parameter
(it is used when the function is called by \code{sen2r()}).}

\item{.log_output}{(optional) Internal parameter
(it is used when the function is called by \code{sen2r()}).}
}
\value{
A vector with the names of the merged products (just created or
already existing).
}
\description{
The function merge the input Sentinel-2 files with
the same date, orbit number, product type and file format.
Outputs are a set of products in the same format of corresponding
input files.
}
\note{
License: GPL 3.0
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019)
}
