% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_phylm.R
\name{tree_phylm}
\alias{tree_phylm}
\title{Phylogenetic uncertainty - Phylogenetic Linear Regression}
\usage{
tree_phylm(formula, data, phy, times = 2, model = "lambda", track = TRUE,
  ...)
}
\arguments{
\item{formula}{The model formula}

\item{data}{Data frame containing species traits with species as row names.}

\item{phy}{A phylogeny (class 'multiPhylo', see ?\code{ape}).}

\item{times}{Number of times to repeat the analysis with n different trees picked 
randomly in the multiPhylo file.
If NULL, \code{times} = 2}

\item{model}{The phylogenetic model to use (see Details). Default is \code{lambda}.}

\item{track}{Print a report tracking function progress (default = TRUE)}

\item{...}{Further arguments to be passed to \code{phylolm}}
}
\value{
The function \code{tree_phylm} returns a list with the following
components:

\code{formula}: The formula

\code{data}: Original full dataset

\code{model_results}: Coefficients, aic and the optimised
value of the phylogenetic parameter (e.g. \code{lambda}) for each regression with a 
different phylogenetic tree.

\code{N.obs}: Size of the dataset after matching it with tree tips and removing NA's.

\code{stats}: Main statistics for model parameters.\code{CI_low} and \code{CI_high} are the lower 
and upper limits of the 95% confidence interval.

\code{all.stats}: Complete statistics for model parameters. \code{sd_intra} is the standard deviation 
due to intraspecific variation. \code{CI_low} and \code{CI_high} are the lower and upper limits 
of the 95% confidence interval.
}
\description{
Performs Phylogenetic linear regression evaluating
uncertainty in trees topology.
}
\details{
This function fits a phylogenetic linear regression model using \code{\link[phylolm]{phylolm}}
to n trees, randomly picked in a multiPhylo file.

All phylogenetic models from \code{phylolm} can be used, i.e. \code{BM},
\code{OUfixedRoot}, \code{OUrandomRoot}, \code{lambda}, \code{kappa},
\code{delta}, \code{EB} and \code{trend}. See ?\code{phylolm} for details.

Currently, this function can only implement simple linear models (i.e. \eqn{trait~
predictor}). In the future we will implement more complex models.

Output can be visualised using \code{sensi_plot}.
}
\examples{
# Load data:
data(alien)
# This analysis needs a multiphylo file:
class(alien$phy)
alien$phy
# run PGLS accounting for phylogenetic uncertain:
tree <- tree_phylm(log(gestaLen) ~ log(adultMass), phy = alien$phy, 
data = alien$data, times = 30)
# To check summary results:
summary(tree)
# Visual diagnostics
sensi_plot(tree)
# You can specify which graph to print: 
sensi_plot(tree, graphs = 3)
}
\author{
Caterina Penone & Pablo Ariel Martinez
}
\references{
Donoghue, M.J. & Ackerly, D.D. (1996). Phylogenetic Uncertainties and 
Sensitivity Analyses in Comparative Biology. Philosophical Transactions:
 Biological Sciences, pp. 1241-1249.
 
Ho, L. S. T. and Ane, C. 2014. "A linear-time algorithm for 
Gaussian and non-Gaussian trait evolution models". Systematic Biology 63(3):397-408.
}
\seealso{
\code{\link[phylolm]{phylolm}}, \code{\link{sensi_plot}}
}

