% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_engines.R
\name{peakdocs}
\alias{peakdocs}
\title{Extract documents related to sentiment peaks}
\usage{
peakdocs(sentiment, n = 10, type = "both", do.average = FALSE)
}
\arguments{
\item{sentiment}{a \code{sentiment} object created using \code{\link{compute_sentiment}} or
\code{\link{as.sentiment}}.}

\item{n}{a positive \code{numeric} value to indicate the number of documents associated to sentiment
peaks to extract. If \code{n < 1}, it is interpreted as a quantile (for example, 0.07 would mean the
7\% most extreme documents).}

\item{type}{a \code{character} value, either \code{"pos"}, \code{"neg"} or \code{"both"}, respectively to look
for the \code{n} documents related to the most positive, most negative or most extreme (in absolute terms) sentiment
occurrences.}

\item{do.average}{a \code{logical} to indicate whether peaks should be selected based on the average sentiment
value per document.}
}
\value{
A vector of type \code{"character"} corresponding to the \code{n} extracted document identifiers.
}
\description{
This function extracts the documents with most extreme sentiment (lowest, highest or both
in absolute terms). The extracted documents are unique, even when, for example, all most extreme
sentiment values (across sentiment calculation methods) occur only for one document.
}
\examples{
set.seed(505)

data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")])

corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 200)
sent <- compute_sentiment(corpusSample, l, how = "proportionalPol")

# extract the peaks
peaksAbs <- peakdocs(sent, n = 5)
peaksAbsQuantile <- peakdocs(sent, n = 0.50)
peaksPos <- peakdocs(sent, n = 5, type = "pos")
peaksNeg <- peakdocs(sent, n = 5, type = "neg")

}
\author{
Samuel Borms
}
