\name{simTrial}
\alias{simTrial}
\title{
Simulation of Multi-Arm Randomized Phase IIb/III  Efficacy Trials with Time-to-Event Endpoints
}
\description{
\code{simTrial} generates independent time-to-event data-sets according to a user-specified trial design. The user makes assumptions about the enrollment, dropout, and infection processes in each treatment arm.
}
\usage{
simTrial(N, aveVE, VEmodel = c("half", "constant"), vePeriods, 
         enrollPeriod, enrollPartial, enrollPartialRelRate, 
         dropoutRate, infecRate, fuTime, visitSchedule, 
         missVaccProb = NULL, VEcutoffWeek, nTrials, blockSize = NULL,
         stage1, saveDir = NULL, verbose = TRUE, randomSeed = NULL)
}
\arguments{
  \item{N}{a numeric vector specifying the numbers of enrolled trial participants per treatment arm. The length of \code{N} equals the total number of treatment arms, and the first component of \code{N} represents the control arm.}
  \item{aveVE}{a numeric vector containing, for each treatment arm in \code{N}, a time-averaged vaccine efficacy (VE), defined as the weighted average of VEs in the time intervals specified by \code{vePeriods}. If \code{VEmodel = "half"}, VE is halved in the initial interval, the full VE is applied in the second interval, and \code{aveVE} is applied thereafter. The components of \code{N} and \code{aveVE} correspond to each other.}
  \item{VEmodel}{a character string specifying whether VE is assumed constant over time (option "\code{constant}") or halved in the initial time interval as defined in \code{vePeriods} (option "\code{half}"). Only the first character is necessary.}
  \item{vePeriods}{a numeric vector defining start times (in weeks) of time intervals with (potentially) distinct VE levels depending on the choice of the \code{VEmodel}}
  \item{enrollPeriod}{the final week of the enrollment period}
  \item{enrollPartial}{the final week of the portion of the enrollment period with a reduced enrollment rate defined by \code{enrollPartialRelRate}}
  \item{enrollPartialRelRate}{a non-negative value characterizing the fraction of the weekly enrollment rate governing enrollment from week 1 until week \code{enrollPartial}}
  \item{dropoutRate}{a (prior) annual dropout rate}
  \item{infecRate}{a (prior) annual infection rate in the control arm}
  \item{fuTime}{a follow-up time (in weeks) of each participant}  
  \item{visitSchedule}{a numeric vector listing the visit weeks at which testing for the endpoint is conducted}
  \item{missVaccProb}{a numeric vector with conditional probabilities of having missed a vaccination given the follow-up time exceeds \code{VEcutoffWeek} weeks. For each component, a separate per-protocol indicator is generated. Each per-protocol cohort includes subjects with (i) a non-missing vaccination, and (ii) follow-up time exceeding \code{VEcutoffWeek} weeks. If \code{NULL}, no per-protocol indicators are included.}
  \item{VEcutoffWeek}{a time cut-off (in weeks); the follow-up time exceeding \code{VEcutoffWeek} weeks is required for inclusion in the per-protocol cohort}
  \item{nTrials}{the number of trials to be simulated}
  \item{blockSize}{a constant block size to be used in permuted-block randomization. The choice of \code{blockSize} requires caution to achieve the desired balance of treatment assignments within a block.}
  \item{stage1}{the final week of stage 1 in a two-stage trial}
  \item{saveDir}{a character string specifying a path for the output directory. If supplied, the output is saved as an \code{.RData} file in the directory; otherwise the output is returned as a list.}
  \item{verbose}{a logical value indicating whether information on the output directory and file name should be printed out (default is \code{TRUE})}
  \item{randomSeed}{sets seed of the random number generator for simulation reproducibility}
}
\details{
All time variables use week as the unit of time. Month is defined as 52/12 weeks.

The prior weekly enrollment rate is calculated based on the duration of the enrollment periods with reduced/full enrollment rates and the total number of subjects to be enrolled.

The weekly enrollment, dropout and infection rates used for generating trial data are sampled from specified prior distributions (the prior annual dropout and infection probabilities are specified by the user). The default choice considers non-random point-mass distributions, i.e., the prior rates directly govern the accumulation of trial data.

Subjects' enrollment is assumed to follow a Poisson process with a time-varying rate (the argument \code{enrollPartialRelRate} characterizes a reduced enrollment rate applied to weeks 1 through \code{enrollPartial}, i.e., full enrollment starts at week \code{enrollPartial}+1). The number of enrolled subjects is determined by the vector \code{N}.

Dropout times are assumed to follow an exponential distribution where the probability of a dropout within 1 week is equal to \code{dropoutRate}/52.

Permuted-block randomization is used for assigning treatment labels. If left unspecified by the user, an appropriate block size, no smaller than 10, will computed and used.  The function \code{getBlockSize} can be used to determine appropriate block sizes (see help(getBlockSize)).

Infection times are generated following the VE schedule characterized by \code{aveVE}, \code{VEmodel} and \code{vePeriods}. Independent exponential times are generated within each time period of constant VE, and their minimum specifies the right-censored infection time. Exponential rates are chosen that satisfy the user-specified requirements on the treatment- and time-period-specific probabilities of an infection within 1 week (in the control arm, the infection probability within 1 week uniformly equals \code{infecRate}/52).

Infection diagnosis times are calculated according to the \code{visitSchedule}. The observed follow-up time is defined as the minumum of the infection diagnosis time, dropout time, and \code{fuTime}.
% describe the generation of enrollment, dropout and infection rates from prior distributions to be used for data simulation (sampleRates)
% describe the data generating process (each step), characterize the distributions/assumptions
}
\value{
If \code{saveDir} is specified, the output list (named \code{trialObj}) is saved as an \code{.RData} file (the output directory path is printed); otherwise it is returned. The output object is a list with the following components:
\item{trialData}{a list with \code{nTrials} components each of which is a \code{data.frame} with at least the variables \code{trt}, \code{entry}, \code{exit}, and \code{event} storing the treatment assignments, enrollment times, study exit times, and event indicators, respectively. The observed follow-up times can be recovered as \code{exit} - \code{entry}. Indicators of belonging to the per-protocol cohort (named \code{pp1}, \code{pp2}, etc.) are included if \code{missVaccProb} is specified.}
\item{NinfStage1}{a list whose components are numeric vectors with the numbers of \code{stage1} infections by treatment (\code{[1]} = control arm) for each simulated trial}
\item{nTrials}{the number of simulated trials}
\item{N}{the total number of enrolled trial participants}
\item{nArms}{the number of treatment arms}
\item{trtAssgnProbs}{a numeric vector containing the treatment assignment probabilities}
\item{blockSize}{the block size used for treatment assignment}
\item{fuTime}{the follow-up time (in weeks) of each participant}
\item{rates}{a list with three components: the prior weekly enrollment rate (\code{enrollment}), the prior probability of dropout within 1 week (\code{dropout}), and the prior probability of infection within 1 week (\code{infection})}
\item{enrollSchedule}{a \code{data.frame} summarizing information on enrollment periods and corresponding relative enrollment rates (relative to the weekly "base" enrollment rate). The column names are \code{start}, \code{end}, and \code{relativeRates}.}
\item{VEs}{a list with components being numeric vectors containing VE levels assumed within time periods defined by \code{vePeriods} for each active treatment arm}
\item{infecRates}{a \code{data.frame} summarizing information on time periods of distinct VE across all treatment arms. The variables \code{trt}, \code{start}, \code{end}, and \code{relRate} carry treatment assignment labels, first and last week of a time interval, and the pertaining assumed hazard ratio in the given interval.}
\item{randomSeed}{the set seed of the random number generator for simulation reproducibility}
}
\seealso{
\code{\link{monitorTrial}}, \code{\link{censTrial}}, and \code{\link{rankTrial}}
}
\examples{
simData <- simTrial(N=c(1000, rep(700, 2)), aveVE=seq(0, 0.4, by=0.2), 
                    VEmodel="half", vePeriods=c(1, 27, 79), enrollPeriod=78, 
                    enrollPartial=13, enrollPartialRelRate=0.5, dropoutRate=0.05, 
                    infecRate=0.04, fuTime=156, 
                    visitSchedule=c(0, (13/3)*(1:4), seq(13*6/3, 156, by=13*2/3)),
                    missVaccProb=c(0,0.05,0.1,0.15), VEcutoffWeek=26, nTrials=5, 
                    blockSize=30, stage1=78, randomSeed=300)

### alternatively, to save the .RData output file (no '<-' needed):
###
### simTrial(N=c(1400, rep(1000, 2)), aveVE=seq(0, 0.4, by=0.2), VEmodel="half", 
###          vePeriods=c(1, 27, 79), enrollPeriod=78, enrollPartial=13, 
###          enrollPartialRelRate=0.5, dropoutRate=0.05, infecRate=0.04, fuTime=156, 
###          visitSchedule=c(0, (13/3)*(1:4), seq(13*6/3, 156, by=13*2/3)), 
###          missVaccProb=c(0,0.05,0.1,0.15), VEcutoffWeek=26, nTrials=30, 
###          blockSize=30, stage1=78, saveDir="./", randomSeed=300)
}
