% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqR_result.R
\name{rbind_columnwise}
\alias{rbind_columnwise}
\title{Bind rows of several k-mer matrices}
\usage{
rbind_columnwise(...)
}
\arguments{
\item{...}{k-mer matrices of type \link[Matrix]{Matrix}}
}
\value{
a k-mer matrix of type \link[Matrix]{Matrix} that is the result of the rbind operation
}
\description{
The function binds rows of several input k-mer matrices (of type \link[Matrix]{Matrix}),
which are results of \link[seqR]{count_kmers} and \link[seqR]{count_multimers}.
This implementation also handles properly k-mer matrices that do not have
the same columns, as opposed to the implementation of \link[base]{rbind}.
}
\examples{

batch_size <- 1

# k-mer counting
resA <- count_kmers(c("AAAAA", "ASASSSSASSA"), k=5, batch_size=batch_size)
resB <- count_multimers(c("HWHSHS", "AASDCASD"), k_vector=c(3, 5), batch_size=batch_size)

# rbind
res <- rbind_columnwise(resA, resB)

}
\seealso{
Function that count k-mers of one type: count_kmers

Function that counts many k-mer variants in the single invocation: count_multimers
}
