% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqminer.R
\name{readSingleChromosomeVCFToMatrixByRange}
\alias{readSingleChromosomeVCFToMatrixByRange}
\title{Read a range from VCF file and return a genotype matrix}
\usage{
readSingleChromosomeVCFToMatrixByRange(fileName, range, indexFileName = NULL)
}
\arguments{
\item{fileName}{character, represents an input VCF file (Bgzipped, with Tabix index)}

\item{range}{character, a text indicating which range in the VCF file to extract. e.g. 1:100-200, 1-based index}

\item{indexFileName}{character, index file, by default, it s `fileName`.scIdx}
}
\value{
genotype matrix
}
\description{
Read a range from VCF file and return a genotype matrix
}
\examples{
fileName = system.file("vcf/all.anno.filtered.extract.vcf.gz", package = "seqminer")
cfh <- readSingleChromosomeVCFToMatrixByRange(fileName, "1:196621007-196716634")
}
\seealso{
http://zhanxw.com/seqminer/ for online manual and examples
}
