% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operation_setintersect.R
\name{setintersect}
\alias{setintersect}
\alias{setintersect.Interval}
\alias{setintersect.ConditionalSet}
\alias{setintersect.UnionSet}
\alias{setintersect.ComplementSet}
\alias{setintersect.ProductSet}
\alias{&.Set}
\title{Intersection of Two Sets}
\usage{
setintersect(x, y)

\method{setintersect}{Interval}(x, y)

\method{setintersect}{ConditionalSet}(x, y)

\method{setintersect}{UnionSet}(x, y)

\method{setintersect}{ComplementSet}(x, y)

\method{setintersect}{ProductSet}(x, y)

\method{&}{Set}(x, y)
}
\arguments{
\item{x, y}{Set}
}
\value{
A \code{Set} consisting of elements in both \code{x} and \code{y}.
}
\description{
Returns the intersection of two objects inheriting from class \code{Set}.
}
\details{
The intersection of two sets, \eqn{X, Y}, is defined as the set of elements that exist
in both sets,
\deqn{X \cap Y = \{z : z \epsilon X \quad and \quad z \epsilon Y\}}{{z : z \epsilon X and z \epsilon Y}}
In the case where no elements are common to either set, then the empty set is returned.

The intersection of two \link{ConditionalSet}s is defined by combining their defining functions by an
'and', \code{&}, operator. See examples.

The intersection of fuzzy and crisp sets first coerces fuzzy sets to crisp sets by finding their support.
}
\examples{
# intersection of two sets

Set$new(-2:4) & Set$new(2:5)
setintersect(Set$new(1, 4, "a"), Set$new("a", 6))
Set$new(1:4) & Set$new(5:7)

# intersection of two intervals

Interval$new(1, 10) & Interval$new(5, 15)
Interval$new(1, 2) & Interval$new(2, 3)
Interval$new(1, 5, class = "integer") &
  Interval$new(2, 7, class = "integer")

# intersection of mixed set types

Set$new(1:10) & Interval$new(5, 15)
Set$new(5, 7) & Tuple$new(6, 8, 7)

# Ignores membership of FuzzySet

FuzzySet$new(1, 0.1, 2, 0.5) & Set$new(2:5)

# intersection of conditional sets

ConditionalSet$new(function(x, y) x >= y) &
  ConditionalSet$new(function(x, y) x == y)
ConditionalSet$new(function(x) x == 2) &
  ConditionalSet$new(function(y) y == 3)

# But be careful not to make an empty set

ConditionalSet$new(function(x) x == 2) &
  ConditionalSet$new(function(x) x == 3)
}
\seealso{
Other operators: 
\code{\link{powerset}()},
\code{\link{setcomplement}()},
\code{\link{setpower}()},
\code{\link{setproduct}()},
\code{\link{setsymdiff}()},
\code{\link{setunion}()}
}
\concept{operators}
