% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_design.R
\name{get_design}
\alias{get_design}
\title{Retrieve a Space-Filling Design}
\usage{
get_design(num_param, num_points, type = "any")
}
\arguments{
\item{num_param}{An integer between two and ten for the number of
characteristics/factors/parameters in the design.}

\item{num_points}{An integer for the number of grid points requested. If
there is no corresponding design, an error is given (when using
\code{get_design()})}

\item{type}{A character string with possible values> \code{"any"},
\code{"audze_eglais"}, \code{"max_min_l1"}, and \code{"max_min_l2"}, A value of \code{"any"} will
choose the first design available (in alphabetical order).}
}
\value{
A tibble (data frame) with columns named \code{X1} to \verb{X\{num_param\}}.
Each column is an integer for the ordered value of the real parameter values.
}
\description{
Obtain a design from
\url{https://www.spacefillingdesigns.nl/}
(if possible) based on how many characteristics (i.e. parameters) and size
(i.e., number of grid points).
}
\examples{
if (rlang::is_installed("ggplot2")) {
 library(ggplot2)

 two_param_l2 <- get_design(2, 100, type = "audze_eglais")

 ggplot(two_param_l2, aes(X1, X2)) +
   geom_point() +
   coord_equal()
}

no_design <- try(get_design(2, 1000), silent = TRUE)
cat(as.character(no_design))
}
\references{
\url{https://www.spacefillingdesigns.nl/},
Husslage, B. G., Rennen, G., Van Dam, E. R., & Den Hertog, D. (2011).
Space-filling Latin hypercube designs for computer experiments. \emph{Optimization
and Engineering}, 12, 611-630.
}
