% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{sf_point}
\alias{sf_point}
\title{sf POINT}
\usage{
sf_point(obj, x = NULL, y = NULL, z = NULL, m = NULL)
}
\arguments{
\item{obj}{sorted vector, matrix or data.frame}

\item{x}{x geometry column}

\item{y}{y geometry column}

\item{z}{z geometry column}

\item{m}{m geometry column}
}
\value{
\code{sf} object of POINT geometries
}
\description{
constructs sf of POINT objects
}
\section{notes}{

sfheaders functions do not perform any validity checks on the geometries.
Nor do they set Coordinate Reference Systems, EPSG, PROJ4 or precision attributes.

The data.frame and matrices you send into the sfheader functions must be ordered.
}

\examples{

x <- c(1:3)
sf_point( x )

x <- matrix( c(1:10) , ncol = 2 )
sf_point( x )

x <- setNames( as.data.frame( x ), c("x","y") )
sf_point( x )
sf_point( obj = x, x = "x", y = "y" )
sf_point( obj = x, x = "y", y = "x" )

}
