% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.sfnetwork}
\alias{plot.sfnetwork}
\title{Plot sfnetwork geometries}
\usage{
\method{plot}{sfnetwork}(x, draw_lines = TRUE, ...)
}
\arguments{
\item{x}{Object of class \code{\link{sfnetwork}}.}

\item{draw_lines}{If the edges of the network are spatially implicit, should
straight lines be drawn between connected nodes? Defaults to \code{TRUE}.
Ignored when the edges of the network are spatially explicit.}

\item{...}{Arguments passed on to \code{\link[sf:plot]{plot.sf}}}
}
\description{
Plot the geometries of an object of class \code{\link{sfnetwork}}.
}
\details{
This is a basic plotting functionality. For more advanced plotting,
it is recommended to extract the nodes and edges from the network, and plot
them separately with one of the many available spatial plotting functions
as can be found in \code{sf}, \code{tmap}, \code{ggplot2}, \code{ggspatial},
and others.
}
\examples{
oldpar = par(no.readonly = TRUE)
par(mar = c(1,1,1,1), mfrow = c(1,1))
net = as_sfnetwork(roxel)
plot(net)

# When lines are spatially implicit.
par(mar = c(1,1,1,1), mfrow = c(1,2))
net = as_sfnetwork(roxel, edges_as_lines = FALSE)
plot(net)
plot(net, draw_lines = FALSE)

# Changing default settings.
par(mar = c(1,1,1,1), mfrow = c(1,1))
plot(net, col = 'blue', pch = 18, lwd = 1, cex = 2)

# Add grid and axis
par(mar = c(2.5,2.5,1,1))
plot(net, graticule = TRUE, axes = TRUE)

par(oldpar)

}
