% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initGMF-class.R
\name{residuals.initgmf}
\alias{residuals.initgmf}
\alias{resid.initgmf}
\title{Extract the residuals of an initialized GMF model}
\usage{
\method{residuals}{initgmf}(
  object,
  ...,
  type = c("deviance", "pearson", "working", "response", "link"),
  partial = FALSE,
  normalize = FALSE,
  fillna = FALSE,
  spectrum = FALSE,
  ncomp = 50
)

\method{resid}{initgmf}(
  object,
  ...,
  type = c("deviance", "pearson", "working", "response", "link"),
  partial = FALSE,
  normalize = FALSE,
  fillna = FALSE,
  spectrum = FALSE,
  ncomp = 50
)
}
\arguments{
\item{object}{an object of class \code{initgmf}}

\item{...}{further arguments passed to or from other methods}

\item{type}{the type of residuals which should be returned}

\item{partial}{if \code{TRUE}, computes the residuals excluding the matrix factorization from the linear predictor}

\item{normalize}{if \code{TRUE}, standardize the residuals column-by-column}

\item{fillna}{if \code{TRUE}, fills \code{NA} values column-by-column}

\item{spectrum}{if \code{TRUE}, returns the eigenvalues of the residual covariance matrix}

\item{ncomp}{number of eigenvalues to be calculated (only if \code{spectrum=TRUE})}
}
\value{
If \code{spectrum=FALSE}, a matrix containing the selected residuals.
If \code{spectrum=TRUE}, a list containing the residuals (\code{res}), the first \code{ncomp}
eigenvalues of the residual covariance matrix, say (\code{lambdas}), the variance explained by the first
\code{ncomp} principal component of the residuals (\code{explained.var}), the variance not
explained by the first \code{ncomp} principal component of the residuals (\code{residual.var}),
the total variance of the residuals (\code{total.var}).
}
\description{
Extract the residuals of an initialized GMF model and, if required, compute
the eigenvalues of the residuals covariance/correlation matrix.
Moreover, if required, return the partial residual of the model obtained by
excluding the matrix decomposition from the linear predictor.
}
\examples{
# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 100, m = 20, ncomp = 5, family = poisson())

# Fit a GMF model with 3 latent factors
init = sgdgmf.init(data$Y, ncomp = 3, family = poisson())

# Get the deviance residuals of a GMF model
str(residuals(init)) # returns the overall deviance residuals
str(residuals(init, partial = TRUE)) # returns the partial residuals
str(residuals(init, spectrum = TRUE)) # returns the eigenvalues of the residual var-cov matrix

}
\seealso{
\code{\link{residuals.sgdgmf}} and \code{\link{resid.sgdgmf}} for more details on the residual computation.
}
