% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qglg.R
\name{qglg}
\alias{qglg}
\title{Quantile function for a generalized log-gamma variable}
\usage{
qglg(x, location, scale, shape)
}
\arguments{
\item{x}{numeric, a real number between 0 and 1.}

\item{location}{numeric, represent the location parameter of a generalized log-gamma distribution. Default value is 0.}

\item{scale}{numeric, represent the scale parameter of a generalized log-gamma distribution. Default value is 1.}

\item{shape}{numeric, represent the shape parameter of a generalized log-gamma distribution. Default value is 1.}
}
\description{
\code{qglg} is used to calculate the quantile function of a generalized log-gamma variable at x.
}
\examples{
x <- runif(3,0,1)
qglg(sort(x),location=0,scale=1,shape=1)
}
\references{
Carlos Alberto Cardozo Delgado, Semi-parametric generalized log-gamma regression models. Ph. D. thesis. Sao Paulo University.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
