% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_systematic.R
\name{sample_systematic}
\alias{sample_systematic}
\title{Systematic sampling}
\usage{
sample_systematic(
  raster,
  cellsize,
  square = TRUE,
  location = "centers",
  force = FALSE,
  access = NULL,
  buff_inner = NULL,
  buff_outer = NULL,
  plot = FALSE,
  filename = NULL,
  overwrite = FALSE,
  details = FALSE,
  ...
)
}
\arguments{
\item{raster}{spatRaster. Raster used to define extent of fishnet grid.}

\item{cellsize}{Numeric. Desired cellsize for tessellation.}

\item{square}{Logical. Tessellation shape. Default is regular square grid,
if \code{FALSE} hexagons are used.}

\item{location}{Character. Sample location within tessellation. \code{Default = "centers"})
returns samples at tessellation centers, \code{"corners"} - corners of tessellation are returned,
\code{"random"} - samples are randomly located within tessellations.}

\item{force}{Logical. Only applies when \code{location = "random"}. If \code{TRUE}, random samples are
forced to fall in areas where \code{raster} does not have \code{NA} values. This will considerably slow processing.}

\item{access}{sf. Road access network - must be lines.}

\item{buff_inner}{Numeric. Inner buffer boundary specifying distance
from access where plots cannot be sampled.}

\item{buff_outer}{Numeric. Outer buffer boundary specifying distance
from access where plots can be sampled.}

\item{plot}{Logical. Plots output strata raster with samples.}

\item{filename}{Character. Path to write output samples.}

\item{overwrite}{Logical. Choice to overwrite existing \code{filename} if it exists.}

\item{details}{Logical. If \code{FALSE} (default) output is sf object of
systematic samples. If \code{TRUE} returns a list of sf objects where \code{tessellation}
is the tessellation grid for sampling, and \code{samples} are the systematic samples.}

\item{...}{Additional arguments for \code{\link[sf]{st_make_grid}}. Options include \code{offset} 
to offset grid by providing lower left coordinates.}
}
\value{
An sf object with sampled points over a tessellation.
}
\description{
Systematic sampling with random start point and translation within a square or hexagonal tessellation.
}
\note{
Specifying \code{location = "random"} can result in tessellations with no samples.
This results from \code{raster} have \code{NA} values at the random location chosen.
Using \code{force = TRUE} removes areas of \code{NA} from sampling entirely, but
considerably slows processing speeds.
}
\examples{
#--- Load raster and access files ---#
r <- system.file("extdata", "sraster.tif", package = "sgsR")
sr <- terra::rast(r)

a <- system.file("extdata", "access.shp", package = "sgsR")
ac <- sf::st_read(a)

e <- system.file("extdata", "existing.shp", package = "sgsR")
e <- sf::st_read(e)

#--- perform grid sampling ---#
sample_systematic(
  raster = sr,
  cellsize = 1000
)

sample_systematic(
  raster = sr,
  cellsize = 1000,
  square = FALSE,
  location = "corners",
  plot = TRUE
)

sample_systematic(
  raster = sr,
  cellsize = 1000,
  square = FALSE,
  location = "random"
)
}
\seealso{
Other sample functions: 
\code{\link{sample_ahels}()},
\code{\link{sample_balanced}()},
\code{\link{sample_clhs}()},
\code{\link{sample_existing}()},
\code{\link{sample_nc}()},
\code{\link{sample_srs}()},
\code{\link{sample_strat}()}
}
\author{
Tristan R.H. Goodbody, Lukas Winiwarter
}
\concept{sample functions}
