% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{rbind.shapviz}
\alias{rbind.shapviz}
\title{Rowbinds Multiple "shapviz" Objects}
\usage{
\method{rbind}{shapviz}(...)
}
\arguments{
\item{...}{Any number of "shapviz" objects.}
}
\value{
A new object of class "shapviz".
}
\description{
Rowbinds multiple "shapviz" objects based on the \code{+} operator.
}
\examples{
S <- matrix(c(1, -1, -1, 1), ncol = 2, dimnames = list(NULL, c("x", "y")))
X <- data.frame(x = c("a", "b"), y = c(100, 10))
s1 <- shapviz(S, X, baseline = 4)[1L]
s2 <- shapviz(S, X, baseline = 4)[2L]
s <- rbind(s1, s2)
s
}
\seealso{
\code{\link[=shapviz]{shapviz()}}
}
