% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/potential_interactions.R
\name{potential_interactions}
\alias{potential_interactions}
\title{Interaction Strength}
\usage{
potential_interactions(
  obj,
  v,
  nbins = NULL,
  color_num = TRUE,
  scale = FALSE,
  adjusted = FALSE
)
}
\arguments{
\item{obj}{An object of class "shapviz".}

\item{v}{Variable name to calculate potential SHAP interactions for.}

\item{nbins}{Into how many quantile bins should a numeric \code{v} be binned?
The default \code{NULL} equals the smaller of \eqn{n/20} and \eqn{\sqrt n} (rounded up),
where \eqn{n} is the sample size. Ignored if \code{obj} contains SHAP interactions.}

\item{color_num}{Should other ("color") features \verb{v'} be converted to numeric,
even if they are factors/characters? Default is \code{TRUE}.
Ignored if \code{obj} contains SHAP interactions.}

\item{scale}{Should adjusted R-squared be multiplied with the sample variance of
within-bin SHAP values? If \code{TRUE}, bins with stronger vertical scatter will get
higher weight. The default is \code{FALSE}. Ignored if \code{obj} contains SHAP interactions.}

\item{adjusted}{Should \emph{adjusted} R-squared be used? Default is \code{FALSE}.}
}
\value{
A named vector of decreasing interaction strengths.
}
\description{
Returns a vector of interaction strengths between variable \code{v} and all other
variables, see Details.
}
\details{
If SHAP interaction values are available, the interaction strength
between feature \code{v} and another feature \verb{v'} is measured by twice their
mean absolute SHAP interaction values.

Otherwise, we use a heuristic calculated as follows:
\enumerate{
\item If \code{v} is numeric, it is binned into \code{nbins} bins.
\item Per bin, the SHAP values of \code{v} are regressed onto \code{v}, and the R-squared
is calculated. Rows with missing \verb{v'} are discarded.
\item The R-squared are averaged over bins, weighted by the number of
non-missing \verb{v'} values.
}

This measures how much variability in the SHAP values of \code{v} is explained by \verb{v'},
after accounting for \code{v}.

Set \code{scale = TRUE} to multiply the R-squared by the within-bin variance
of the SHAP values. This will put higher weight to bins with larger scatter.

Set \code{color_num = FALSE} to \emph{not} turn the values of the "color" feature \verb{v'}
to numeric.

Finally, set \code{adjusted = TRUE} to use \emph{adjusted} R-squared.

The algorithm does not consider observations with missing \verb{v'} values.
}
\seealso{
\code{\link[=sv_dependence]{sv_dependence()}}
}
