% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_raster.R
\name{translate_raster}
\alias{translate_raster}
\title{translate_raster}
\usage{
translate_raster(
  raster,
  steps_x = NULL,
  steps_y = NULL,
  return_input = TRUE,
  simplify = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{raster}{SpatRaster with discrete habitat classes.}

\item{steps_x, steps_y}{Integer with number of steps (cells) the raster is translated
into the corresponding direction. If both are null, all possible combinations are used
resulting in n = ((50 + 1) * (50 + 1)) - 4 rasters.}

\item{return_input}{Logical if the original input data is returned.}

\item{simplify}{Logical if only the raster will be returned if \code{n_random = 1}
and \code{return_input = FALSE}.}

\item{verbose}{Logical if progress report is printed.}
}
\value{
rd_ras
}
\description{
Torus translation
}
\details{
Torus translation test as described in Harms et al. (2001). The raster is shifted
in all four cardinal directions by steps equal to the raster resolution. If a cell
exits the extent on one side, it enters the extent on the opposite side.

The method does not allow any NA values to be present in the SpatRaster.
}
\examples{
\dontrun{
landscape_classified <- classify_habitats(terra::rast(landscape), n = 5, style = "fisher")

landscape_random <- translate_raster(landscape_classified)
landscape_random_sub <- translate_raster(landscape_classified,
steps_x = 1:10, steps_y = 1:5)
}

}
\references{
Harms, K.E., Condit, R., Hubbell, S.P., Foster, R.B., 2001. Habitat associations
of trees and shrubs in a 50-ha neotropical forest plot. Journal of Ecology 89, 947–959.
<https://doi.org/10.1111/j.1365-2745.2001.00615.x>
}
\seealso{
\code{\link{randomize_raster}}
}
