% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability_score.R
\name{ConsensusScore}
\alias{ConsensusScore}
\title{Consensus score}
\usage{
ConsensusScore(coprop, nc, K = 100, linkage = "complete")
}
\arguments{
\item{coprop}{consensus matrix obtained with \code{nc} clusters across
\code{K} subsampling iterations.}

\item{nc}{number of clusters.}

\item{K}{number of subsampling iterations.}

\item{linkage}{character string indicating the type of linkage used in
hierarchical clustering to define the stable clusters. Possible values
include \code{"complete"}, \code{"single"} and \code{"average"} (see
argument \code{"method"} in \code{\link[stats]{hclust}} for a full list).}
}
\value{
A consensus score between 0 and 1.
}
\description{
Computes the consensus score from the consensus matrix. The score measures
how unlikely it is that the clustering procedure is uniform (i.e.
uninformative) for a given combination of parameters.
}
\details{
Let \eqn{\Gamma(\lambda, G)} be the consensus matrix. We introduce
  the matrix \eqn{H(\lambda, G)} of co-membership count corrected for the
  subsampling procedure, defined as the integer part of \eqn{K
  \Gamma(\lambda, G)}.

  Under the hypothesis of equiprobability of co-membership (instability), we
  assume that the co-membership counts follow the same binomial distribution
  for all pairs of items.

  Given stable clusters \eqn{Z} and hyper-parameters \eqn{(\lambda, G)},
  clustering stability is measured as the probability \eqn{p_{\lambda,
  G}(H|z)} of observing co-membership counts in \eqn{H} that are at least as
  high within clusters and at least as low between clusters under
  equiprobability:

  \eqn{p_{\lambda, G}(H|Z) = \prod_{i < j} F(H_{ij})^{1_{Z_i=/=Z_j}}
  \times (1 - F(H_{ij}))^{1_{Z_i=Z_j}}}

  where \eqn{F(x)} is the cumulative probability function of the binomial
  distribution with parameters \eqn{K} and probability \eqn{\gamma = N_c/N}
  with \eqn{N_c} the number of stable co-members and \eqn{N} the number of
  item pairs.

  This probability is minimised at \eqn{H^s}, which corresponding to the most
  stable clustering and is defined as:

  \eqn{H^s_{ij} = K \times 1_{Z_i = Z_j}}

  The consensus score is calculated as the following standardised
  probability:

  \eqn{S_c(\lambda, G) = (p_{\lambda, G}(H (\lambda, G)|Z)) / (p_{\lambda,
  G}(H^s|Z))}

  The consensus score increases with clustering stability.
}
\examples{

# Data simulation
set.seed(2)
simul <- SimulateClustering(
  n = c(30, 30, 30),
  nu_xc = 1
)
plot(simul)

# Consensus clustering
stab <- Clustering(
  xdata = simul$data
)
stab$Sc[3]

# Calculating the consensus score
ConsensusScore(
  coprop = stab$coprop[, , 3],
  nc = stab$nc[3]
)

}
\seealso{
Other stability metric functions: 
\code{\link{FDP}()},
\code{\link{PFER}()},
\code{\link{StabilityMetrics}()},
\code{\link{StabilityScore}()}
}
\concept{stability metric functions}
